/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.apiary.extensions.events.metastore.consumer.privilegesgrantor.core;

import com.expediagroup.apiary.extensions.events.metastore.consumer.common.exception.HiveClientException;
import com.expediagroup.apiary.extensions.events.metastore.consumer.privilegesgrantor.core.Grantor;
import com.expediagroup.apiary.extensions.events.metastore.consumer.privilegesgrantor.core.PrincipalName;
import com.expediagroup.apiary.extensions.events.metastore.consumer.privilegesgrantor.core.Privilege;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivilegesGrantor {
    private static final Logger log = LoggerFactory.getLogger(PrivilegesGrantor.class);
    private final IMetaStoreClient client;

    public PrivilegesGrantor(IMetaStoreClient client) {
        this.client = client;
    }

    public void grantSelectPrivileges(String dbName, String tableName) {
        log.info("Granting Public Select Privileges to the table: " + tableName);
        try {
            if (this.isSelectPrivilegeGranted(dbName, tableName)) {
                log.info("Skipping Granting Public privileges, the privilege is already granted on the table: " + tableName);
            } else {
                PrivilegeBag privilegeBag = new PrivilegeBag();
                privilegeBag.addToPrivileges(this.getPublicSelectPrivilege(dbName, tableName));
                this.client.grant_privileges(privilegeBag);
                log.info("Successfully granted Public Select Privileges to the table: " + tableName);
            }
        }
        catch (TException e) {
            throw new HiveClientException("Error Granting Public Select Privileges to the table: " + tableName, (Throwable)e);
        }
    }

    public boolean isSelectPrivilegeGranted(String dbName, String tableName) {
        HiveObjectRef hiveObjectRef = new HiveObjectRef();
        hiveObjectRef.setDbName(dbName);
        hiveObjectRef.setObjectType(HiveObjectType.TABLE);
        hiveObjectRef.setObjectName(tableName);
        try {
            return this.client.list_privileges(PrincipalName.PUBLIC.toString(), PrincipalType.ROLE, hiveObjectRef).stream().anyMatch(privilege -> privilege.getGrantInfo().getPrivilege().equals(Privilege.SELECT.toString()));
        }
        catch (TException e) {
            throw new HiveClientException("Error checking if Select Privilege is granted on the table: " + tableName, (Throwable)e);
        }
    }

    private HiveObjectPrivilege getPublicSelectPrivilege(String dbName, String tableName) {
        HiveObjectRef hiveObjectRef = new HiveObjectRef();
        hiveObjectRef.setDbName(dbName);
        hiveObjectRef.setObjectType(HiveObjectType.TABLE);
        hiveObjectRef.setObjectName(tableName);
        PrivilegeGrantInfo privilegeGrantInfo = new PrivilegeGrantInfo(Privilege.SELECT.toString(), 0, Grantor.APIARY_PRIVILEGE_GRANTOR.toString(), PrincipalType.ROLE, false);
        HiveObjectPrivilege hiveObjectPrivilege = new HiveObjectPrivilege();
        hiveObjectPrivilege.setHiveObject(hiveObjectRef);
        hiveObjectPrivilege.setPrincipalName(PrincipalName.PUBLIC.toString());
        hiveObjectPrivilege.setPrincipalType(PrincipalType.ROLE);
        hiveObjectPrivilege.setGrantInfo(privilegeGrantInfo);
        return hiveObjectPrivilege;
    }
}

