/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.apiary.extensions.events.metastore.consumer.common.thrift;

import com.expediagroup.apiary.extensions.events.metastore.consumer.common.exception.HiveClientException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;

public class ThriftHiveClient {
    private IMetaStoreClient client;
    private static final String DEFAULT_TIMEOUT = "5000";

    public ThriftHiveClient(String hiveMetaStoreUris) {
        this(hiveMetaStoreUris, DEFAULT_TIMEOUT);
    }

    public ThriftHiveClient(String hiveMetaStoreUris, String hiveMetastoreClientSocketTimeout) {
        try {
            HiveConf hiveConf = new HiveConf();
            hiveConf.setVar(HiveConf.ConfVars.METASTOREURIS, hiveMetaStoreUris);
            if (hiveMetastoreClientSocketTimeout != null) {
                hiveConf.setVar(HiveConf.ConfVars.METASTORE_CLIENT_SOCKET_TIMEOUT, hiveMetastoreClientSocketTimeout);
            }
            this.client = new HiveMetaStoreClient(hiveConf);
        }
        catch (Exception e) {
            throw new HiveClientException("Error creating Hive metastore client", e);
        }
    }

    public IMetaStoreClient getMetaStoreClient() {
        return this.client;
    }
}

