/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.beekeeper.core.context;

import com.expediagroup.beekeeper.core.config.GraphiteConfigFactory;
import com.expediagroup.beekeeper.core.config.PrometheusConfigFactory;
import io.micrometer.core.aop.TimedAspect;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.graphite.GraphiteConfig;
import io.micrometer.graphite.GraphiteMeterRegistry;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import org.springframework.boot.actuate.autoconfigure.metrics.MeterRegistryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MonitoringContext {
    @Bean
    GraphiteMeterRegistry meterRegistry(GraphiteConfigFactory graphiteConfigFactory) {
        GraphiteConfig graphiteConfig = graphiteConfigFactory.newInstance();
        GraphiteMeterRegistry graphiteMeterRegistry = new GraphiteMeterRegistry(graphiteConfig, Clock.SYSTEM, (id, convention) -> graphiteConfig.prefix() + "." + HierarchicalNameMapper.DEFAULT.toHierarchicalName(id, convention));
        graphiteMeterRegistry.config().namingConvention(NamingConvention.dot);
        return graphiteMeterRegistry;
    }

    @Bean
    MeterRegistryCustomizer<MeterRegistry> metricsCommonTags(PrometheusConfigFactory prometheusConfigFactory) {
        return registry -> {
            if (registry instanceof PrometheusMeterRegistry) {
                registry.config().commonTags(new String[]{"application", prometheusConfigFactory.newInstance().prefix()});
            }
        };
    }

    @Bean
    public TimedAspect timedAspect(MeterRegistry registry) {
        return new TimedAspect(registry);
    }
}

