/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.beekeeper.core.model;

import com.expediagroup.beekeeper.core.error.BeekeeperException;
import com.expediagroup.beekeeper.core.model.DurationConverter;
import com.expediagroup.beekeeper.core.model.HousekeepingEntity;
import com.expediagroup.beekeeper.core.model.HousekeepingStatus;
import com.expediagroup.beekeeper.core.monitoring.MetricTag;
import java.time.Duration;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name="housekeeping_path")
public class HousekeepingPath
implements HousekeepingEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="path", nullable=false, unique=true)
    private String path;
    @Column(name="database_name")
    private String databaseName;
    @Column(name="table_name")
    private String tableName;
    @Column(name="housekeeping_status", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private HousekeepingStatus housekeepingStatus;
    @Column(name="creation_timestamp", nullable=false, updatable=false)
    private LocalDateTime creationTimestamp;
    @Column(name="modified_timestamp")
    @UpdateTimestamp
    private LocalDateTime modifiedTimestamp;
    @Column(name="cleanup_timestamp", nullable=false)
    private LocalDateTime cleanupTimestamp;
    @Column(name="cleanup_delay", nullable=false)
    @Convert(converter=DurationConverter.class)
    private Duration cleanupDelay;
    @Column(name="cleanup_attempts", nullable=false)
    private int cleanupAttempts;
    @Column(name="client_id")
    private String clientId;
    @Column(name="lifecycle_type", nullable=false)
    private String lifecycleType;

    public HousekeepingPath() {
    }

    private HousekeepingPath(Long id, String path, String databaseName, String tableName, HousekeepingStatus housekeepingStatus, LocalDateTime creationTimestamp, LocalDateTime modifiedTimestamp, LocalDateTime cleanupTimestamp, Duration cleanupDelay, int cleanupAttempts, String lifecycleType, String clientId) {
        this.id = id;
        this.path = path;
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.housekeepingStatus = housekeepingStatus;
        this.creationTimestamp = creationTimestamp;
        this.modifiedTimestamp = modifiedTimestamp;
        this.cleanupTimestamp = cleanupTimestamp;
        this.cleanupDelay = cleanupDelay;
        this.cleanupAttempts = cleanupAttempts;
        this.lifecycleType = lifecycleType;
        this.clientId = clientId;
    }

    @Override
    public String getLifecycleType() {
        return this.lifecycleType;
    }

    public void setLifecycleType(String lifecycleType) {
        this.lifecycleType = lifecycleType;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public HousekeepingStatus getHousekeepingStatus() {
        return this.housekeepingStatus;
    }

    public void setHousekeepingStatus(HousekeepingStatus housekeepingStatus) {
        this.housekeepingStatus = housekeepingStatus;
    }

    @Override
    public LocalDateTime getCreationTimestamp() {
        return this.creationTimestamp;
    }

    @Override
    public LocalDateTime getModifiedTimestamp() {
        return this.modifiedTimestamp;
    }

    @Override
    public LocalDateTime getCleanupTimestamp() {
        return this.cleanupTimestamp;
    }

    public void setCleanupTimestamp(LocalDateTime cleanupTimestamp) {
        this.cleanupTimestamp = cleanupTimestamp;
    }

    @Override
    public int getCleanupAttempts() {
        return this.cleanupAttempts;
    }

    public void setCleanupAttempts(int cleanupAttempts) {
        this.cleanupAttempts = cleanupAttempts;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public Duration getCleanupDelay() {
        return this.cleanupDelay;
    }

    public void setCleanupDelay(Duration cleanupDelay) {
        this.cleanupDelay = cleanupDelay;
        this.cleanupTimestamp = this.creationTimestamp.plus(cleanupDelay);
    }

    @Override
    public MetricTag getMetricTag() {
        return new MetricTag("table", String.join((CharSequence)".", this.databaseName, this.tableName));
    }

    public String toString() {
        return String.format("%s(path=%s, databaseName=%s, tableName=%s, housekeepingStatus=%s, creationTimestamp=%s, modifiedTimestamp=%s, cleanupTimestamp=%s, cleanupDelay=%s, cleanupAttempts=%s, clientId=%s, lifecycleType=%s)", new Object[]{HousekeepingPath.class.getSimpleName(), this.path, this.databaseName, this.tableName, this.housekeepingStatus, this.creationTimestamp, this.modifiedTimestamp, this.cleanupTimestamp, this.cleanupDelay, this.cleanupAttempts, this.clientId, this.lifecycleType});
    }

    public static final class Builder {
        private Long id;
        private String path;
        private String databaseName;
        private String tableName;
        private HousekeepingStatus housekeepingStatus;
        private LocalDateTime creationTimestamp;
        private LocalDateTime modifiedTimestamp;
        private LocalDateTime cleanupTimestamp;
        private Duration cleanupDelay;
        private int cleanupAttempts;
        private String clientId;
        private String lifecycleType;

        public Builder id(Long id) {
            this.id = id;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder housekeepingStatus(HousekeepingStatus housekeepingStatus) {
            this.housekeepingStatus = housekeepingStatus;
            return this;
        }

        public Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder creationTimestamp(LocalDateTime creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public Builder modifiedTimestamp(LocalDateTime modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
            return this;
        }

        public Builder cleanupDelay(Duration cleanupDelay) {
            this.cleanupDelay = cleanupDelay;
            return this;
        }

        public Builder cleanupAttempts(int cleanupAttempts) {
            this.cleanupAttempts = cleanupAttempts;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public HousekeepingPath build() {
            this.cleanupTimestamp = this.configureCleanupTimestamp();
            return new HousekeepingPath(this.id, this.path, this.databaseName, this.tableName, this.housekeepingStatus, this.creationTimestamp, this.modifiedTimestamp, this.cleanupTimestamp, this.cleanupDelay, this.cleanupAttempts, this.lifecycleType, this.clientId);
        }

        private LocalDateTime configureCleanupTimestamp() {
            if (this.creationTimestamp == null) {
                throw new BeekeeperException("Path requires a creation timestamp");
            }
            if (this.cleanupDelay == null) {
                throw new BeekeeperException("Path requires a cleanup delay");
            }
            return this.creationTimestamp.plus(this.cleanupDelay);
        }

        public Builder lifecycleType(String lifecycleType) {
            this.lifecycleType = lifecycleType;
            return this;
        }
    }
}

