/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.beekeeper.core.config;

import com.expediagroup.beekeeper.core.error.BeekeeperException;
import io.micrometer.graphite.GraphiteConfig;
import io.micrometer.graphite.GraphiteProtocol;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="graphite")
public class GraphiteConfigFactory {
    private static int DEFAULT_GRAPHITE_PORT = 2003;
    private static String DEFAULT_GRAPHITE_HOST = "localhost";
    private boolean enabled;
    private String host;
    private String prefix;
    private int port = DEFAULT_GRAPHITE_PORT;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public GraphiteConfig newInstance() {
        if (!this.enabled) {
            return new DefaultGraphiteConfig();
        }
        if (this.host == null) {
            throw new BeekeeperException("If Graphite is enabled, graphite.host must be set.");
        }
        if (this.prefix == null) {
            throw new BeekeeperException("If Graphite is enabled, graphite.prefix must be set.");
        }
        return new DefaultGraphiteConfig(true, this.host, this.prefix, this.port);
    }

    private static class DefaultGraphiteConfig
    implements GraphiteConfig {
        private boolean enabled;
        private String host;
        private String prefix;
        private int port;

        public DefaultGraphiteConfig() {
            this(false, DEFAULT_GRAPHITE_HOST, null, DEFAULT_GRAPHITE_PORT);
        }

        public DefaultGraphiteConfig(boolean enabled, String host, String prefix, int port) {
            this.enabled = enabled;
            this.host = host;
            this.prefix = prefix;
            this.port = port;
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        public String prefix() {
            return this.prefix;
        }

        public boolean enabled() {
            return this.enabled;
        }

        public GraphiteProtocol protocol() {
            return GraphiteProtocol.PLAINTEXT;
        }

        public String get(String key) {
            return null;
        }
    }
}

