/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.beekeeper.core.monitoring;

import com.expediagroup.beekeeper.core.monitoring.MetricTag;
import com.expediagroup.beekeeper.core.monitoring.Taggable;
import com.expediagroup.beekeeper.core.monitoring.TimedTaggable;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TimedTaggableAspect {
    public static final String EXCEPTION_TAG = "exception";
    private MeterRegistry meterRegistry;

    @Autowired
    public TimedTaggableAspect(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Around(value="@annotation(timedTaggable) && args(taggable,..)")
    public Object time(ProceedingJoinPoint pjp, Taggable taggable, TimedTaggable timedTaggable) throws Throwable {
        Object object;
        String metricName = timedTaggable.value();
        Timer.Sample sample = Timer.start((MeterRegistry)this.meterRegistry);
        String exceptionClass = "none";
        try {
            object = pjp.proceed();
        }
        catch (Exception ex) {
            try {
                exceptionClass = ex.getClass().getSimpleName();
                throw ex;
            }
            catch (Throwable throwable) {
                try {
                    sample.stop(Timer.builder((String)metricName).tags(new String[]{EXCEPTION_TAG, exceptionClass}).tags((Iterable)this.metricTags(pjp, taggable.getMetricTag())).register(this.meterRegistry));
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            sample.stop(Timer.builder((String)metricName).tags(new String[]{EXCEPTION_TAG, exceptionClass}).tags((Iterable)this.metricTags(pjp, taggable.getMetricTag())).register(this.meterRegistry));
            return object;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    private Tags metricTags(ProceedingJoinPoint pjp, MetricTag metricTag) {
        Tags tags = Tags.of((String[])new String[]{"class", pjp.getStaticPart().getSignature().getDeclaringTypeName(), "method", pjp.getStaticPart().getSignature().getName()});
        if (!StringUtils.isBlank((CharSequence)metricTag.getTag()) && !StringUtils.isBlank((CharSequence)metricTag.getKey())) {
            tags = tags.and(metricTag.getKey(), metricTag.getTag());
        }
        return tags;
    }
}

