/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.beekeeper.core.repository;

import com.expediagroup.beekeeper.core.model.HousekeepingMetadata;
import java.time.LocalDateTime;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface HousekeepingMetadataRepository
extends JpaRepository<HousekeepingMetadata, Long> {
    @Query(value="from HousekeepingMetadata t where t.cleanupTimestamp <= :instant and (t.housekeepingStatus = 'SCHEDULED' or t.housekeepingStatus = 'FAILED') and t.modifiedTimestamp <= :instant order by t.modifiedTimestamp")
    public Page<HousekeepingMetadata> findRecordsForCleanupByModifiedTimestamp(@Param(value="instant") LocalDateTime var1, Pageable var2);

    @Query(value="from HousekeepingMetadata t where t.databaseName = :databaseName and t.tableName = :tableName and (t.partitionName = :partitionName or (:partitionName is NULL and t.partitionName is NULL)) and (t.housekeepingStatus = 'SCHEDULED' or t.housekeepingStatus = 'FAILED')")
    public Optional<HousekeepingMetadata> findRecordForCleanupByDbTableAndPartitionName(@Param(value="databaseName") String var1, @Param(value="tableName") String var2, @Param(value="partitionName") String var3);

    @Query(value="select max(cleanupTimestamp) from HousekeepingMetadata t where t.databaseName = :databaseName and t.tableName = :tableName and (t.housekeepingStatus = 'SCHEDULED' or t.housekeepingStatus = 'FAILED')")
    public LocalDateTime findMaximumCleanupTimestampForDbAndTable(@Param(value="databaseName") String var1, @Param(value="tableName") String var2);

    @Query(value="select count(partitionName) from HousekeepingMetadata t where t.databaseName = :databaseName and t.tableName = :tableName and (t.housekeepingStatus = 'SCHEDULED' or t.housekeepingStatus = 'FAILED')")
    public Long countRecordsForGivenDatabaseAndTableWherePartitionIsNotNull(@Param(value="databaseName") String var1, @Param(value="tableName") String var2);

    @Query(value="select count(partitionName) from HousekeepingMetadata t where t.databaseName = :databaseName and t.tableName = :tableName and (t.housekeepingStatus = 'SCHEDULED' or t.housekeepingStatus = 'FAILED') and t.cleanupTimestamp >= :instant")
    public Long countRecordsForDryRunWherePartitionIsNotNullOrExpired(@Param(value="instant") LocalDateTime var1, @Param(value="databaseName") String var2, @Param(value="tableName") String var3);
}

