/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.beekeeper.metadata.cleanup.context;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.expediagroup.beekeeper.cleanup.aws.S3Client;
import com.expediagroup.beekeeper.cleanup.aws.S3PathCleaner;
import com.expediagroup.beekeeper.cleanup.aws.S3SentinelFilesCleaner;
import com.expediagroup.beekeeper.cleanup.hive.HiveClientFactory;
import com.expediagroup.beekeeper.cleanup.hive.HiveMetadataCleaner;
import com.expediagroup.beekeeper.cleanup.metadata.CleanerClientFactory;
import com.expediagroup.beekeeper.cleanup.metadata.MetadataCleaner;
import com.expediagroup.beekeeper.cleanup.monitoring.BytesDeletedReporter;
import com.expediagroup.beekeeper.cleanup.monitoring.DeletedMetadataReporter;
import com.expediagroup.beekeeper.cleanup.path.PathCleaner;
import com.expediagroup.beekeeper.cleanup.path.SentinelFilesCleaner;
import com.expediagroup.beekeeper.cleanup.service.CleanupService;
import com.expediagroup.beekeeper.cleanup.service.DisableTablesService;
import com.expediagroup.beekeeper.cleanup.service.RepositoryCleanupService;
import com.expediagroup.beekeeper.core.repository.HousekeepingMetadataRepository;
import com.expediagroup.beekeeper.metadata.cleanup.handler.ExpiredMetadataHandler;
import com.expediagroup.beekeeper.metadata.cleanup.handler.MetadataHandler;
import com.expediagroup.beekeeper.metadata.cleanup.service.MetadataDisableTablesService;
import com.expediagroup.beekeeper.metadata.cleanup.service.MetadataRepositoryCleanupService;
import com.expediagroup.beekeeper.metadata.cleanup.service.PagingMetadataCleanupService;
import com.hotels.hcommon.hive.metastore.client.api.CloseableMetaStoreClient;
import com.hotels.hcommon.hive.metastore.client.api.MetaStoreClientFactory;
import com.hotels.hcommon.hive.metastore.client.closeable.CloseableMetaStoreClientFactory;
import com.hotels.hcommon.hive.metastore.client.supplier.HiveMetaStoreClientSupplier;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import java.util.function.Supplier;
import org.apache.hadoop.hive.conf.HiveConf;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@EnableScheduling
@ComponentScan(value={"com.expediagroup.beekeeper.core", "com.expediagroup.beekeeper.cleanup"})
@EntityScan(basePackages={"com.expediagroup.beekeeper.core.model"})
@EnableJpaRepositories(basePackages={"com.expediagroup.beekeeper.core.repository"})
public class CommonBeans {
    @Bean
    public HiveConf hiveConf(@Value(value="${properties.metastore-uri}") String metastoreUri) {
        HiveConf conf = new HiveConf();
        conf.setVar(HiveConf.ConfVars.METASTOREURIS, metastoreUri);
        return conf;
    }

    @Bean
    public CloseableMetaStoreClientFactory metaStoreClientFactory() {
        return new CloseableMetaStoreClientFactory();
    }

    @Bean
    Supplier<CloseableMetaStoreClient> metaStoreClientSupplier(CloseableMetaStoreClientFactory metaStoreClientFactory, HiveConf hiveConf) {
        String name = "beekeeper-metadata-cleanup";
        return new HiveMetaStoreClientSupplier((MetaStoreClientFactory)metaStoreClientFactory, hiveConf, name);
    }

    @Bean(name={"hiveClientFactory"})
    public CleanerClientFactory clientFactory(Supplier<CloseableMetaStoreClient> metaStoreClientSupplier, @Value(value="${properties.dry-run-enabled}") boolean dryRunEnabled) {
        return new HiveClientFactory(metaStoreClientSupplier, dryRunEnabled);
    }

    @Bean
    public DeletedMetadataReporter deletedMetadataReporter(MeterRegistry meterRegistry, @Value(value="${properties.dry-run-enabled}") boolean dryRunEnabled) {
        return new DeletedMetadataReporter(meterRegistry, dryRunEnabled);
    }

    @Bean(name={"hiveTableCleaner"})
    MetadataCleaner metadataCleaner(DeletedMetadataReporter deletedMetadataReporter) {
        return new HiveMetadataCleaner(deletedMetadataReporter);
    }

    @Bean
    @Profile(value={"default"})
    public AmazonS3 amazonS3() {
        return AmazonS3ClientBuilder.defaultClient();
    }

    @Bean
    @Profile(value={"test"})
    AmazonS3 amazonS3Test() {
        String s3Endpoint = System.getProperty("aws.s3.endpoint");
        String region = System.getProperty("aws.region");
        return (AmazonS3)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(s3Endpoint, region))).build();
    }

    @Bean
    BytesDeletedReporter bytesDeletedReporter(MeterRegistry meterRegistry, @Value(value="${properties.dry-run-enabled}") boolean dryRunEnabled) {
        return new BytesDeletedReporter(meterRegistry, dryRunEnabled);
    }

    @Bean
    public S3Client s3Client(AmazonS3 amazonS3, @Value(value="${properties.dry-run-enabled}") boolean dryRunEnabled) {
        return new S3Client(amazonS3, dryRunEnabled);
    }

    @Bean(name={"s3PathCleaner"})
    PathCleaner pathCleaner(S3Client s3Client, BytesDeletedReporter bytesDeletedReporter) {
        return new S3PathCleaner(s3Client, (SentinelFilesCleaner)new S3SentinelFilesCleaner(s3Client), bytesDeletedReporter);
    }

    @Bean(name={"expiredMetadataHandler"})
    public ExpiredMetadataHandler expiredMetadataHandler(@Qualifier(value="hiveClientFactory") CleanerClientFactory cleanerClientFactory, HousekeepingMetadataRepository housekeepingMetadataRepository, @Qualifier(value="hiveTableCleaner") MetadataCleaner metadataCleaner, @Qualifier(value="s3PathCleaner") PathCleaner pathCleaner) {
        return new ExpiredMetadataHandler(cleanerClientFactory, housekeepingMetadataRepository, metadataCleaner, pathCleaner);
    }

    @Bean
    CleanupService cleanupService(List<MetadataHandler> metadataHandlers, @Value(value="${properties.cleanup-page-size}") int pageSize, @Value(value="${properties.dry-run-enabled}") boolean dryRunEnabled) {
        return new PagingMetadataCleanupService(metadataHandlers, pageSize, dryRunEnabled);
    }

    @Bean
    RepositoryCleanupService repositoryCleanupService(HousekeepingMetadataRepository housekeepingMetadataRepository, @Value(value="${properties.old-data-retention-period-days}") int retentionPeriodInDays) {
        return new MetadataRepositoryCleanupService(housekeepingMetadataRepository, retentionPeriodInDays);
    }

    @Bean
    DisableTablesService disableTablesService(HousekeepingMetadataRepository housekeepingMetadataRepository, CleanerClientFactory cleanerClientFactory, @Value(value="${properties.dry-run-enabled}") boolean dryRunEnabled) {
        return new MetadataDisableTablesService(cleanerClientFactory, housekeepingMetadataRepository, dryRunEnabled);
    }
}

