/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.beekeeper.metadata.cleanup.handler;

import com.expediagroup.beekeeper.cleanup.metadata.CleanerClient;
import com.expediagroup.beekeeper.cleanup.metadata.CleanerClientFactory;
import com.expediagroup.beekeeper.cleanup.metadata.MetadataCleaner;
import com.expediagroup.beekeeper.cleanup.path.PathCleaner;
import com.expediagroup.beekeeper.core.model.HousekeepingEntity;
import com.expediagroup.beekeeper.core.model.HousekeepingMetadata;
import com.expediagroup.beekeeper.core.model.HousekeepingStatus;
import com.expediagroup.beekeeper.core.repository.HousekeepingMetadataRepository;
import com.expediagroup.beekeeper.core.validation.S3PathValidator;
import com.expediagroup.beekeeper.metadata.cleanup.handler.MetadataHandler;
import java.time.LocalDateTime;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;

public class ExpiredMetadataHandler
implements MetadataHandler {
    private final Logger log = LoggerFactory.getLogger(ExpiredMetadataHandler.class);
    private final CleanerClientFactory cleanerClientFactory;
    private final HousekeepingMetadataRepository housekeepingMetadataRepository;
    private final MetadataCleaner metadataCleaner;
    private final PathCleaner pathCleaner;

    public ExpiredMetadataHandler(CleanerClientFactory cleanerClientFactory, HousekeepingMetadataRepository housekeepingMetadataRepository, MetadataCleaner metadataCleaner, PathCleaner pathCleaner) {
        this.cleanerClientFactory = cleanerClientFactory;
        this.housekeepingMetadataRepository = housekeepingMetadataRepository;
        this.metadataCleaner = metadataCleaner;
        this.pathCleaner = pathCleaner;
    }

    @Override
    public Slice<HousekeepingMetadata> findRecordsToClean(LocalDateTime instant, Pageable pageable) {
        return this.housekeepingMetadataRepository.findRecordsForCleanupByModifiedTimestamp(instant, pageable);
    }

    @Override
    public void cleanupMetadata(HousekeepingMetadata housekeepingMetadata, LocalDateTime instant, boolean dryRunEnabled) {
        try (CleanerClient client = this.cleanerClientFactory.newInstance();){
            boolean deleted = this.cleanup(client, housekeepingMetadata, instant, dryRunEnabled);
            if (deleted && !dryRunEnabled) {
                this.updateAttemptsAndStatus(housekeepingMetadata, HousekeepingStatus.DELETED);
            }
        }
        catch (Exception e) {
            this.updateAttemptsAndStatus(housekeepingMetadata, HousekeepingStatus.FAILED);
            this.log.warn("Unexpected exception when deleting metadata for table \"{}.{}\"", new Object[]{housekeepingMetadata.getDatabaseName(), housekeepingMetadata.getTableName(), e});
        }
    }

    private boolean cleanup(CleanerClient client, HousekeepingMetadata housekeepingMetadata, LocalDateTime instant, boolean dryRunEnabled) {
        String partitionName = housekeepingMetadata.getPartitionName();
        if (partitionName != null) {
            return this.cleanupPartition(client, housekeepingMetadata, dryRunEnabled);
        }
        Long partitionCount = this.countPartitionsForDatabaseAndTable(instant, housekeepingMetadata.getDatabaseName(), housekeepingMetadata.getTableName(), dryRunEnabled);
        if (partitionCount.equals(NumberUtils.LONG_ZERO)) {
            return this.cleanUpTable(client, housekeepingMetadata, dryRunEnabled);
        }
        return false;
    }

    private boolean cleanUpTable(CleanerClient client, HousekeepingMetadata housekeepingMetadata, boolean dryRunEnabled) {
        if (!S3PathValidator.validTablePath((String)housekeepingMetadata.getPath())) {
            this.log.warn("Will not clean up table path \"{}\" because it is not valid.", (Object)housekeepingMetadata.getPath());
            this.updateStatus(housekeepingMetadata, HousekeepingStatus.SKIPPED, dryRunEnabled);
            return false;
        }
        String databaseName = housekeepingMetadata.getDatabaseName();
        String tableName = housekeepingMetadata.getTableName();
        this.log.info("Cleaning up metadata for \"{}.{}\"", (Object)databaseName, (Object)tableName);
        if (this.metadataCleaner.tableExists(client, databaseName, tableName)) {
            this.metadataCleaner.dropTable(housekeepingMetadata, client);
            this.pathCleaner.cleanupPath((HousekeepingEntity)housekeepingMetadata);
        } else {
            this.log.info("Cannot drop table \"{}.{}\". Table does not exist.", (Object)databaseName, (Object)tableName);
        }
        return true;
    }

    private boolean cleanupPartition(CleanerClient client, HousekeepingMetadata housekeepingMetadata, boolean dryRunEnabled) {
        if (!S3PathValidator.validPartitionPath((String)housekeepingMetadata.getPath())) {
            this.log.warn("Will not clean up partition path \"{}\" because it is not valid.", (Object)housekeepingMetadata.getPath());
            this.updateStatus(housekeepingMetadata, HousekeepingStatus.SKIPPED, dryRunEnabled);
            return false;
        }
        String databaseName = housekeepingMetadata.getDatabaseName();
        String tableName = housekeepingMetadata.getTableName();
        this.log.info("Cleaning up metadata for \"{}.{}\"", (Object)databaseName, (Object)tableName);
        if (this.metadataCleaner.tableExists(client, databaseName, tableName)) {
            boolean partitionDeleted = this.metadataCleaner.dropPartition(housekeepingMetadata, client);
            if (partitionDeleted) {
                this.pathCleaner.cleanupPath((HousekeepingEntity)housekeepingMetadata);
            }
        } else {
            this.log.info("Cannot drop partition \"{}\" from table \"{}.{}\". Table does not exist.", new Object[]{housekeepingMetadata.getPartitionName(), databaseName, tableName});
        }
        return true;
    }

    private void updateAttemptsAndStatus(HousekeepingMetadata housekeepingMetadata, HousekeepingStatus status) {
        housekeepingMetadata.setCleanupAttempts(housekeepingMetadata.getCleanupAttempts() + 1);
        housekeepingMetadata.setHousekeepingStatus(status);
        this.housekeepingMetadataRepository.save((Object)housekeepingMetadata);
    }

    private void updateStatus(HousekeepingMetadata housekeepingMetadata, HousekeepingStatus status, boolean dryRunEnabled) {
        if (dryRunEnabled) {
            return;
        }
        housekeepingMetadata.setHousekeepingStatus(status);
        this.housekeepingMetadataRepository.save((Object)housekeepingMetadata);
    }

    private Long countPartitionsForDatabaseAndTable(LocalDateTime instant, String databaseName, String tableName, boolean dryRunEnabled) {
        if (dryRunEnabled) {
            return this.housekeepingMetadataRepository.countRecordsForDryRunWherePartitionIsNotNullOrExpired(instant, databaseName, tableName);
        }
        return this.housekeepingMetadataRepository.countRecordsForGivenDatabaseAndTableWherePartitionIsNotNull(databaseName, tableName);
    }
}

