/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.beekeeper.metadata.cleanup.service;

import com.expediagroup.beekeeper.cleanup.metadata.CleanerClient;
import com.expediagroup.beekeeper.cleanup.metadata.CleanerClientFactory;
import com.expediagroup.beekeeper.cleanup.service.DisableTablesService;
import com.expediagroup.beekeeper.core.error.BeekeeperException;
import com.expediagroup.beekeeper.core.model.HousekeepingMetadata;
import com.expediagroup.beekeeper.core.model.HousekeepingStatus;
import com.expediagroup.beekeeper.core.model.LifecycleEventType;
import com.expediagroup.beekeeper.core.repository.HousekeepingMetadataRepository;
import io.micrometer.core.annotation.Timed;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class MetadataDisableTablesService
implements DisableTablesService {
    private static final Logger log = LoggerFactory.getLogger(MetadataDisableTablesService.class);
    private final CleanerClientFactory cleanerClientFactory;
    private final HousekeepingMetadataRepository housekeepingMetadataRepository;
    private final boolean dryRunEnabled;

    public MetadataDisableTablesService(CleanerClientFactory cleanerClientFactory, HousekeepingMetadataRepository housekeepingMetadataRepository, boolean dryRunEnabled) {
        this.cleanerClientFactory = cleanerClientFactory;
        this.housekeepingMetadataRepository = housekeepingMetadataRepository;
        this.dryRunEnabled = dryRunEnabled;
    }

    @Timed(value="metadata-disable-tables-job")
    @Transactional
    public void disable() {
        List activeTables = this.housekeepingMetadataRepository.findActiveTables();
        activeTables.forEach(this::handleTable);
    }

    private void handleTable(HousekeepingMetadata table) {
        if (!this.tableHasBeekeeperProperty(table)) {
            log.info("Disabling table {}.{}", (Object)table.getDatabaseName(), (Object)table.getTableName());
            if (!this.dryRunEnabled) {
                this.housekeepingMetadataRepository.deleteScheduledOrFailedPartitionRecordsForTable(table.getDatabaseName(), table.getTableName());
                table.setHousekeepingStatus(HousekeepingStatus.DISABLED);
                this.housekeepingMetadataRepository.save((Object)table);
            }
        }
    }

    private boolean tableHasBeekeeperProperty(HousekeepingMetadata metadata) {
        boolean bl;
        block8: {
            CleanerClient client = this.cleanerClientFactory.newInstance();
            try {
                Map properties = client.getTableProperties(metadata.getDatabaseName(), metadata.getTableName());
                String beekeeperProperty = (String)properties.get(LifecycleEventType.EXPIRED.getTableParameterName());
                bl = "true".equals(beekeeperProperty);
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new BeekeeperException("Can't instantiate cleaner client.", (Exception)e);
                }
            }
            client.close();
        }
        return bl;
    }
}

