/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.beekeeper.metadata.cleanup.service;

import com.expediagroup.beekeeper.cleanup.service.RepositoryCleanupService;
import com.expediagroup.beekeeper.core.repository.HousekeepingMetadataRepository;
import io.micrometer.core.annotation.Timed;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import org.springframework.transaction.annotation.Transactional;

public class MetadataRepositoryCleanupService
implements RepositoryCleanupService {
    private final HousekeepingMetadataRepository housekeepingMetadataRepository;
    private final int retentionPeriodInDays;

    public MetadataRepositoryCleanupService(HousekeepingMetadataRepository housekeepingMetadataRepository, int retentionPeriodInDays) {
        this.housekeepingMetadataRepository = housekeepingMetadataRepository;
        this.retentionPeriodInDays = retentionPeriodInDays;
    }

    @Transactional
    @Timed(value="metadata-repository-cleanup-job")
    public void cleanUp(Instant referenceTime) {
        LocalDateTime instant = LocalDateTime.ofInstant(referenceTime, ZoneOffset.UTC);
        this.housekeepingMetadataRepository.cleanUpOldDeletedRecords(instant.minus(this.retentionPeriodInDays, ChronoUnit.DAYS));
    }
}

