/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.beekeeper.metadata.cleanup.service;

import com.expediagroup.beekeeper.cleanup.service.CleanupService;
import com.expediagroup.beekeeper.core.error.BeekeeperException;
import com.expediagroup.beekeeper.core.model.HousekeepingMetadata;
import com.expediagroup.beekeeper.metadata.cleanup.handler.MetadataHandler;
import io.micrometer.core.annotation.Timed;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.transaction.annotation.Transactional;

public class PagingMetadataCleanupService
implements CleanupService {
    private final List<MetadataHandler> metadataHandlers;
    private final boolean dryRunEnabled;
    private final int pageSize;

    public PagingMetadataCleanupService(List<MetadataHandler> metadataHandlers, int pageSize, boolean dryRunEnabled) {
        this.metadataHandlers = metadataHandlers;
        this.pageSize = pageSize;
        this.dryRunEnabled = dryRunEnabled;
    }

    @Timed(value="metadata-cleanup-job")
    public void cleanUp(Instant referenceTime) {
        try {
            this.metadataHandlers.forEach(handler -> this.pagingCleanup((MetadataHandler)handler, referenceTime));
        }
        catch (Exception e) {
            throw new BeekeeperException(String.format("Metadata cleanup failed for instant %s", referenceTime.toString()), e);
        }
    }

    @Transactional
    private void pagingCleanup(MetadataHandler handler, Instant referenceTime) {
        PageRequest pageable = PageRequest.of((int)0, (int)this.pageSize).first();
        LocalDateTime instant = LocalDateTime.ofInstant(referenceTime, ZoneOffset.UTC);
        Slice<HousekeepingMetadata> batch = handler.findRecordsToClean(instant, (Pageable)pageable);
        while (!batch.getContent().isEmpty()) {
            pageable = this.processPage(handler, (Pageable)pageable, instant, batch);
            batch = handler.findRecordsToClean(instant, (Pageable)pageable);
        }
    }

    private Pageable processPage(MetadataHandler handler, Pageable pageable, LocalDateTime instant, Slice<HousekeepingMetadata> batch) {
        batch.getContent().forEach(metadata -> handler.cleanupMetadata((HousekeepingMetadata)metadata, instant, this.dryRunEnabled));
        if (this.dryRunEnabled) {
            return pageable.next();
        }
        return pageable;
    }
}

