/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.beekeeper.path.cleanup.handler;

import com.expediagroup.beekeeper.cleanup.path.PathCleaner;
import com.expediagroup.beekeeper.core.model.HousekeepingPath;
import com.expediagroup.beekeeper.core.model.LifecycleEventType;
import com.expediagroup.beekeeper.core.repository.HousekeepingPathRepository;
import com.expediagroup.beekeeper.path.cleanup.handler.GenericPathHandler;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class UnreferencedPathHandler
extends GenericPathHandler {
    private final HousekeepingPathRepository housekeepingPathRepository;

    @Autowired
    public UnreferencedPathHandler(HousekeepingPathRepository housekeepingPathRepository, @Qualifier(value="s3PathCleaner") PathCleaner pathCleaner) {
        super(housekeepingPathRepository, pathCleaner, LifecycleEventType.UNREFERENCED);
        this.housekeepingPathRepository = housekeepingPathRepository;
    }

    @Override
    public Page<HousekeepingPath> findRecordsToClean(LocalDateTime instant, Pageable pageable) {
        return this.housekeepingPathRepository.findRecordsForCleanupByModifiedTimestamp(instant, pageable);
    }
}

