/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.beekeeper.path.cleanup;

import com.google.common.annotations.VisibleForTesting;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.TimeZone;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

@SpringBootApplication
@EnableConfigurationProperties
public class BeekeeperPathCleanup
implements ApplicationContextAware {
    private static MeterRegistry meterRegistry;
    private static ConfigurableApplicationContext context;

    public static void main(String[] args) {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        new SpringApplicationBuilder(new Class[]{BeekeeperPathCleanup.class}).properties(new String[]{"spring.config.additional-location:classpath:/beekeeper-path-cleanup-application.yml,${config:/}"}).build().run(args);
    }

    @VisibleForTesting
    public static boolean isRunning() {
        return context != null && context.isRunning();
    }

    @VisibleForTesting
    public static void stop() {
        if (context == null) {
            throw new RuntimeException("Application context has not been started.");
        }
        context.close();
    }

    @VisibleForTesting
    public static MeterRegistry meterRegistry() {
        return meterRegistry;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = (ConfigurableApplicationContext)applicationContext;
        meterRegistry = (MeterRegistry)context.getBean("compositeMeterRegistry");
    }
}

