/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.beekeeper.path.cleanup.context;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.expediagroup.beekeeper.cleanup.aws.S3Client;
import com.expediagroup.beekeeper.cleanup.aws.S3PathCleaner;
import com.expediagroup.beekeeper.cleanup.aws.S3SentinelFilesCleaner;
import com.expediagroup.beekeeper.cleanup.monitoring.BytesDeletedReporter;
import com.expediagroup.beekeeper.cleanup.path.PathCleaner;
import com.expediagroup.beekeeper.cleanup.path.SentinelFilesCleaner;
import com.expediagroup.beekeeper.cleanup.service.CleanupService;
import com.expediagroup.beekeeper.cleanup.service.DisableTablesService;
import com.expediagroup.beekeeper.cleanup.service.RepositoryCleanupService;
import com.expediagroup.beekeeper.core.repository.HousekeepingPathRepository;
import com.expediagroup.beekeeper.path.cleanup.handler.GenericPathHandler;
import com.expediagroup.beekeeper.path.cleanup.service.PagingPathCleanupService;
import com.expediagroup.beekeeper.path.cleanup.service.PathRepositoryCleanupService;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@EnableScheduling
@ComponentScan(value={"com.expediagroup.beekeeper.core", "com.expediagroup.beekeeper.cleanup"})
@EntityScan(basePackages={"com.expediagroup.beekeeper.core.model"})
@EnableJpaRepositories(basePackages={"com.expediagroup.beekeeper.core.repository"})
public class CommonBeans {
    @Bean
    @Profile(value={"default"})
    public AmazonS3 amazonS3() {
        return AmazonS3ClientBuilder.defaultClient();
    }

    @Bean
    @Profile(value={"test"})
    AmazonS3 amazonS3Test() {
        String s3Endpoint = System.getProperty("aws.s3.endpoint");
        String region = System.getProperty("aws.region");
        AwsClientBuilder.EndpointConfiguration endpointConfiguration = new AwsClientBuilder.EndpointConfiguration(s3Endpoint, region);
        return (AmazonS3)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(endpointConfiguration)).build();
    }

    @Bean
    BytesDeletedReporter bytesDeletedReporter(MeterRegistry meterRegistry, @Value(value="${properties.dry-run-enabled}") boolean dryRunEnabled) {
        return new BytesDeletedReporter(meterRegistry, dryRunEnabled);
    }

    @Bean
    public S3Client s3Client(AmazonS3 amazonS3, @Value(value="${properties.dry-run-enabled}") boolean dryRunEnabled) {
        return new S3Client(amazonS3, dryRunEnabled);
    }

    @Bean(name={"s3PathCleaner"})
    PathCleaner pathCleaner(S3Client s3Client, BytesDeletedReporter bytesDeletedReporter) {
        return new S3PathCleaner(s3Client, (SentinelFilesCleaner)new S3SentinelFilesCleaner(s3Client), bytesDeletedReporter);
    }

    @Bean
    CleanupService cleanupService(List<GenericPathHandler> pathHandlers, @Value(value="${properties.cleanup-page-size}") int pageSize, @Value(value="${properties.dry-run-enabled}") boolean dryRunEnabled) {
        return new PagingPathCleanupService(pathHandlers, pageSize, dryRunEnabled);
    }

    @Bean
    RepositoryCleanupService repositoryCleanupService(HousekeepingPathRepository housekeepingPathRepository, @Value(value="${properties.old-data-retention-period-days}") int retentionPeriodInDays) {
        return new PathRepositoryCleanupService(housekeepingPathRepository, retentionPeriodInDays);
    }

    @Bean
    DisableTablesService disableTablesService() {
        return () -> {};
    }
}

