/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.beekeeper.path.cleanup.handler;

import com.expediagroup.beekeeper.cleanup.path.PathCleaner;
import com.expediagroup.beekeeper.core.model.HousekeepingEntity;
import com.expediagroup.beekeeper.core.model.HousekeepingPath;
import com.expediagroup.beekeeper.core.model.HousekeepingStatus;
import com.expediagroup.beekeeper.core.model.LifecycleEventType;
import com.expediagroup.beekeeper.core.repository.HousekeepingPathRepository;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public abstract class GenericPathHandler {
    private final Logger log = LoggerFactory.getLogger(GenericPathHandler.class);
    private HousekeepingPathRepository housekeepingPathRepository;
    private PathCleaner pathCleaner;
    private LifecycleEventType lifecycleEventType;

    public GenericPathHandler(HousekeepingPathRepository housekeepingPathRepository, PathCleaner pathCleaner, LifecycleEventType lifecycleEventType) {
        this.housekeepingPathRepository = housekeepingPathRepository;
        this.pathCleaner = pathCleaner;
        this.lifecycleEventType = lifecycleEventType;
    }

    public abstract Page<HousekeepingPath> findRecordsToClean(LocalDateTime var1, Pageable var2);

    public Pageable processPage(Pageable pageable, Page<HousekeepingPath> page, boolean dryRunEnabled) {
        List pageContent = page.getContent();
        if (dryRunEnabled) {
            pageContent.forEach(this::cleanUpPath);
            return pageable.next();
        }
        pageContent.forEach(this::cleanupContent);
        return pageable;
    }

    private void cleanUpPath(HousekeepingPath housekeepingPath) {
        this.pathCleaner.cleanupPath((HousekeepingEntity)housekeepingPath);
    }

    private void cleanupContent(HousekeepingPath housekeepingPath) {
        try {
            this.log.info("Cleaning up path \"{}\"", (Object)housekeepingPath.getPath());
            this.cleanUpPath(housekeepingPath);
            this.updateAttemptsAndStatus(housekeepingPath, HousekeepingStatus.DELETED);
        }
        catch (Exception e) {
            this.updateAttemptsAndStatus(housekeepingPath, HousekeepingStatus.FAILED);
            this.log.warn("Unexpected exception deleting \"{}\"", (Object)housekeepingPath.getPath(), (Object)e);
        }
    }

    private void updateAttemptsAndStatus(HousekeepingPath housekeepingPath, HousekeepingStatus status) {
        housekeepingPath.setCleanupAttempts(housekeepingPath.getCleanupAttempts() + 1);
        housekeepingPath.setHousekeepingStatus(status);
        this.housekeepingPathRepository.save((Object)housekeepingPath);
    }
}

