/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.beekeeper.path.cleanup.service;

import com.expediagroup.beekeeper.cleanup.service.CleanupService;
import com.expediagroup.beekeeper.core.error.BeekeeperException;
import com.expediagroup.beekeeper.core.model.HousekeepingPath;
import com.expediagroup.beekeeper.path.cleanup.handler.GenericPathHandler;
import io.micrometer.core.annotation.Timed;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public class PagingPathCleanupService
implements CleanupService {
    private static final Logger log = LoggerFactory.getLogger(PagingPathCleanupService.class);
    private final List<GenericPathHandler> pathHandlers;
    private final boolean dryRunEnabled;
    private final int pageSize;

    public PagingPathCleanupService(List<GenericPathHandler> pathHandlers, int pageSize, boolean dryRunEnabled) {
        this.pathHandlers = pathHandlers;
        this.pageSize = pageSize;
        this.dryRunEnabled = dryRunEnabled;
    }

    @Timed(value="path-cleanup-job")
    public void cleanUp(Instant referenceTime) {
        try {
            this.pathHandlers.forEach(handler -> this.pagingCleanup((GenericPathHandler)handler, referenceTime));
        }
        catch (Exception e) {
            throw new BeekeeperException(String.format("Cleanup failed for instant %s", referenceTime.toString()), e);
        }
    }

    @Transactional
    private void pagingCleanup(GenericPathHandler handler, Instant referenceTime) {
        Pageable pageable = PageRequest.of((int)0, (int)this.pageSize).first();
        LocalDateTime instant = LocalDateTime.ofInstant(referenceTime, ZoneOffset.UTC);
        Page<HousekeepingPath> page = handler.findRecordsToClean(instant, pageable);
        int i = 1;
        while (!page.getContent().isEmpty()) {
            log.info("Processing page {}", (Object)i++);
            pageable = handler.processPage(pageable, page, this.dryRunEnabled);
            page = handler.findRecordsToClean(instant, pageable);
        }
    }
}

