/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.beekeeper.path.cleanup.service;

import com.expediagroup.beekeeper.cleanup.service.RepositoryCleanupService;
import com.expediagroup.beekeeper.core.repository.HousekeepingPathRepository;
import io.micrometer.core.annotation.Timed;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import org.springframework.transaction.annotation.Transactional;

public class PathRepositoryCleanupService
implements RepositoryCleanupService {
    private final HousekeepingPathRepository housekeepingPathRepository;
    private final int numberOfRetentionDays;

    public PathRepositoryCleanupService(HousekeepingPathRepository housekeepingPathRepository, int numberOfRetentionDays) {
        this.housekeepingPathRepository = housekeepingPathRepository;
        this.numberOfRetentionDays = numberOfRetentionDays;
    }

    @Transactional
    @Timed(value="path-repository-cleanup-job")
    public void cleanUp(Instant referenceTime) {
        LocalDateTime instant = LocalDateTime.ofInstant(referenceTime, ZoneOffset.UTC);
        this.housekeepingPathRepository.cleanUpOldDeletedRecords(instant.minus(this.numberOfRetentionDays, ChronoUnit.DAYS));
    }
}

