/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.beekeeper.scheduler.service;

import com.expediagroup.beekeeper.core.error.BeekeeperException;
import com.expediagroup.beekeeper.core.model.HousekeepingEntity;
import com.expediagroup.beekeeper.core.model.HousekeepingMetadata;
import com.expediagroup.beekeeper.core.model.LifecycleEventType;
import com.expediagroup.beekeeper.core.monitoring.TimedTaggable;
import com.expediagroup.beekeeper.core.repository.HousekeepingMetadataRepository;
import com.expediagroup.beekeeper.scheduler.service.SchedulerService;
import java.time.LocalDateTime;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExpiredHousekeepingMetadataSchedulerService
implements SchedulerService {
    private static final Logger log = LoggerFactory.getLogger(ExpiredHousekeepingMetadataSchedulerService.class);
    private static final LifecycleEventType LIFECYCLE_EVENT_TYPE = LifecycleEventType.EXPIRED;
    private final HousekeepingMetadataRepository housekeepingMetadataRepository;

    @Autowired
    public ExpiredHousekeepingMetadataSchedulerService(HousekeepingMetadataRepository housekeepingMetadataRepository) {
        this.housekeepingMetadataRepository = housekeepingMetadataRepository;
    }

    @Override
    public LifecycleEventType getLifecycleEventType() {
        return LIFECYCLE_EVENT_TYPE;
    }

    @Override
    @TimedTaggable(value="metadata-scheduled")
    public void scheduleForHousekeeping(HousekeepingEntity housekeepingEntity) {
        HousekeepingMetadata housekeepingMetadata = this.createOrUpdateHousekeepingMetadata((HousekeepingMetadata)housekeepingEntity);
        try {
            this.housekeepingMetadataRepository.save((Object)housekeepingMetadata);
            log.info(String.format("Successfully scheduled %s", housekeepingMetadata));
        }
        catch (Exception e) {
            throw new BeekeeperException(String.format("Unable to schedule %s", housekeepingMetadata), e);
        }
    }

    private HousekeepingMetadata createOrUpdateHousekeepingMetadata(HousekeepingMetadata housekeepingMetadata) {
        Optional housekeepingMetadataOptional = this.housekeepingMetadataRepository.findRecordForCleanupByDbTableAndPartitionName(housekeepingMetadata.getDatabaseName(), housekeepingMetadata.getTableName(), housekeepingMetadata.getPartitionName());
        if (housekeepingMetadataOptional.isEmpty()) {
            if (housekeepingMetadata.getPartitionName() != null) {
                this.updateTableCleanupTimestamp(housekeepingMetadata);
            }
            return housekeepingMetadata;
        }
        HousekeepingMetadata existingHousekeepingMetadata = (HousekeepingMetadata)housekeepingMetadataOptional.get();
        existingHousekeepingMetadata.setPath(housekeepingMetadata.getPath());
        existingHousekeepingMetadata.setHousekeepingStatus(housekeepingMetadata.getHousekeepingStatus());
        existingHousekeepingMetadata.setCleanupDelay(housekeepingMetadata.getCleanupDelay());
        existingHousekeepingMetadata.setClientId(housekeepingMetadata.getClientId());
        if (this.isPartitionedTable(housekeepingMetadata)) {
            this.updateTableCleanupTimestampToMax(existingHousekeepingMetadata);
        }
        return existingHousekeepingMetadata;
    }

    private void updateTableCleanupTimestampToMax(HousekeepingMetadata housekeepingMetadata) {
        LocalDateTime currentCleanupTimestamp = housekeepingMetadata.getCleanupTimestamp();
        LocalDateTime maxCleanupTimestamp = this.housekeepingMetadataRepository.findMaximumCleanupTimestampForDbAndTable(housekeepingMetadata.getDatabaseName(), housekeepingMetadata.getTableName());
        if (maxCleanupTimestamp != null && maxCleanupTimestamp.isAfter(currentCleanupTimestamp)) {
            log.info("Updating entry for \"{}.{}\". Cleanup timestamp is now \"{}\".", new Object[]{housekeepingMetadata.getDatabaseName(), housekeepingMetadata.getTableName(), maxCleanupTimestamp});
            housekeepingMetadata.setCleanupTimestamp(maxCleanupTimestamp);
        }
    }

    private void updateTableCleanupTimestamp(HousekeepingMetadata partitionMetadata) {
        LocalDateTime currentCleanupTimestamp;
        HousekeepingMetadata tableMetadata = (HousekeepingMetadata)this.housekeepingMetadataRepository.findRecordForCleanupByDbTableAndPartitionName(partitionMetadata.getDatabaseName(), partitionMetadata.getTableName(), null).get();
        LocalDateTime partitionCleanupTimestamp = partitionMetadata.getCleanupTimestamp();
        if (partitionCleanupTimestamp.isAfter(currentCleanupTimestamp = tableMetadata.getCleanupTimestamp())) {
            log.info("Updating entry for \"{}.{}\". Cleanup timestamp is now \"{}\".", new Object[]{tableMetadata.getDatabaseName(), tableMetadata.getTableName(), partitionCleanupTimestamp});
            tableMetadata.setCleanupTimestamp(partitionCleanupTimestamp);
            this.housekeepingMetadataRepository.save((Object)tableMetadata);
        }
    }

    private boolean isPartitionedTable(HousekeepingMetadata housekeepingMetadata) {
        Long numPartitions = this.housekeepingMetadataRepository.countRecordsForGivenDatabaseAndTableWherePartitionIsNotNull(housekeepingMetadata.getDatabaseName(), housekeepingMetadata.getTableName());
        return numPartitions > 0L && housekeepingMetadata.getPartitionName() == null;
    }
}

