/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.beekeeper.scheduler.service;

import com.expediagroup.beekeeper.core.error.BeekeeperException;
import com.expediagroup.beekeeper.core.model.HousekeepingEntity;
import com.expediagroup.beekeeper.core.model.HousekeepingPath;
import com.expediagroup.beekeeper.core.model.LifecycleEventType;
import com.expediagroup.beekeeper.core.monitoring.TimedTaggable;
import com.expediagroup.beekeeper.core.repository.HousekeepingPathRepository;
import com.expediagroup.beekeeper.scheduler.service.SchedulerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnreferencedHousekeepingPathSchedulerService
implements SchedulerService {
    private static final Logger log = LoggerFactory.getLogger(UnreferencedHousekeepingPathSchedulerService.class);
    private static final LifecycleEventType LIFECYCLE_EVENT_TYPE = LifecycleEventType.UNREFERENCED;
    private final HousekeepingPathRepository housekeepingPathRepository;

    @Autowired
    public UnreferencedHousekeepingPathSchedulerService(HousekeepingPathRepository housekeepingPathRepository) {
        this.housekeepingPathRepository = housekeepingPathRepository;
    }

    @Override
    public LifecycleEventType getLifecycleEventType() {
        return LIFECYCLE_EVENT_TYPE;
    }

    @Override
    @TimedTaggable(value="paths-scheduled")
    public void scheduleForHousekeeping(HousekeepingEntity housekeepingEntity) {
        HousekeepingPath housekeepingPath = (HousekeepingPath)housekeepingEntity;
        try {
            this.housekeepingPathRepository.save((Object)housekeepingPath);
            log.info(String.format("Successfully scheduled %s", housekeepingPath));
        }
        catch (Exception e) {
            throw new BeekeeperException(String.format("Unable to schedule %s", housekeepingPath), e);
        }
    }
}

