/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.plugin.gradle.tasks;

import com.expediagroup.graphql.plugin.GenerateClientKt;
import com.expediagroup.graphql.plugin.generator.GraphQLClientGeneratorConfig;
import com.expediagroup.graphql.plugin.generator.ScalarConverterMapping;
import com.expediagroup.graphql.plugin.gradle.tasks.GraphQLGenerateClientTask;
import com.squareup.kotlinpoet.FileSpec;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001f\u001a\u00020 H\u0007J\u001e\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020#0$H\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0007R\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0007R\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0007R\u0016\u0010\u0015\u001a\u00020\u00168\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u00020\u001a8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0007\u00a8\u0006%"}, d2={"Lcom/expediagroup/graphql/plugin/gradle/tasks/GraphQLGenerateClientTask;", "Lorg/gradle/api/DefaultTask;", "()V", "allowDeprecatedFields", "Lorg/gradle/api/provider/Property;", "", "getAllowDeprecatedFields", "()Lorg/gradle/api/provider/Property;", "converters", "Lorg/gradle/api/provider/MapProperty;", "", "Lcom/expediagroup/graphql/plugin/generator/ScalarConverterMapping;", "getConverters", "()Lorg/gradle/api/provider/MapProperty;", "outputDirectory", "Lorg/gradle/api/file/Directory;", "getOutputDirectory", "packageName", "getPackageName", "queryFileDirectory", "getQueryFileDirectory", "queryFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getQueryFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "schemaFile", "Lorg/gradle/api/file/RegularFileProperty;", "getSchemaFile", "()Lorg/gradle/api/file/RegularFileProperty;", "schemaFileName", "getSchemaFileName", "generateGraphQLClientAction", "", "logConfiguration", "schema", "Ljava/io/File;", "", "graphql-kotlin-gradle-plugin"})
public class GraphQLGenerateClientTask
extends DefaultTask {
    @Input
    @Optional
    @Option(option="schemaFileName", description="path to GraphQL schema file that will be used to generate the client code")
    @NotNull
    private final Property<String> schemaFileName;
    @InputFile
    @Optional
    @NotNull
    private final RegularFileProperty schemaFile;
    @Input
    @Option(option="packageName", description="target package name to use for generated classes")
    @NotNull
    private final Property<String> packageName;
    @Input
    @Optional
    @Option(option="allowDeprecatedFields", description="boolean flag indicating whether selection of deprecated fields is allowed or not")
    @NotNull
    private final Property<Boolean> allowDeprecatedFields;
    @Input
    @Optional
    @NotNull
    private final MapProperty<String, ScalarConverterMapping> converters;
    @Input
    @Optional
    @Option(option="queryFileDirectory", description="directory containing query files")
    @NotNull
    private final Property<String> queryFileDirectory;
    @InputFiles
    @Optional
    @NotNull
    private final ConfigurableFileCollection queryFiles;
    @OutputDirectory
    @NotNull
    private final Property<Directory> outputDirectory;

    @NotNull
    public final Property<String> getSchemaFileName() {
        return this.schemaFileName;
    }

    @NotNull
    public final RegularFileProperty getSchemaFile() {
        return this.schemaFile;
    }

    @NotNull
    public final Property<String> getPackageName() {
        return this.packageName;
    }

    @NotNull
    public final Property<Boolean> getAllowDeprecatedFields() {
        return this.allowDeprecatedFields;
    }

    @NotNull
    public final MapProperty<String, ScalarConverterMapping> getConverters() {
        return this.converters;
    }

    @NotNull
    public final Property<String> getQueryFileDirectory() {
        return this.queryFileDirectory;
    }

    @NotNull
    public final ConfigurableFileCollection getQueryFiles() {
        return this.queryFiles;
    }

    @NotNull
    public final Property<Directory> getOutputDirectory() {
        return this.outputDirectory;
    }

    @TaskAction
    public final void generateGraphQLClientAction() {
        Object object;
        File file;
        this.getLogger().debug("generating GraphQL client");
        if (this.schemaFile.isPresent()) {
            Object object2 = this.schemaFile.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"schemaFile.get()");
            file = ((RegularFile)object2).getAsFile();
        } else if (this.schemaFileName.isPresent()) {
            file = new File((String)this.schemaFileName.get());
        } else {
            throw (Throwable)new RuntimeException("schema not available");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"when {\n            schem\u2026not available\")\n        }");
        File graphQLSchema = file;
        if (!graphQLSchema.isFile()) {
            throw (Throwable)new RuntimeException("specified schema file does not exist");
        }
        String string = (String)this.packageName.getOrNull();
        if (string == null) {
            throw (Throwable)new RuntimeException("package not specified");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"packageName.orNull ?: th\u2026(\"package not specified\")");
        String targetPackage = string;
        Set set = this.queryFiles.getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"queryFiles.files");
        Collection collection = set;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Set set2 = this.queryFiles.getFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"queryFiles.files");
            object = CollectionsKt.toList((Iterable)set2);
        } else if (this.queryFileDirectory.isPresent()) {
            object = new File((String)this.queryFileDirectory.get()).listFiles(generateGraphQLClientAction.targetQueryFiles.1.INSTANCE);
            if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
                throw (Throwable)new RuntimeException("exception while looking up the query files");
            }
        } else {
            throw (Throwable)new RuntimeException("no query files found");
        }
        Object[] targetQueryFiles2 = object;
        if (targetQueryFiles2.isEmpty()) {
            throw (Throwable)new RuntimeException("no query files specified");
        }
        Object object3 = this.outputDirectory.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"outputDirectory.get()");
        File file2 = ((Directory)object3).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"outputDirectory.get().asFile");
        File targetDirectory = file2;
        if (!targetDirectory.isDirectory() && !targetDirectory.mkdirs()) {
            throw (Throwable)new RuntimeException("failed to generate generated source directory");
        }
        this.logConfiguration(graphQLSchema, (List<? extends File>)targetQueryFiles2);
        Object object4 = this.allowDeprecatedFields.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"allowDeprecatedFields.get()");
        boolean bl2 = (Boolean)object4;
        Object object5 = this.converters.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"converters.get()");
        GraphQLClientGeneratorConfig config = new GraphQLClientGeneratorConfig(targetPackage, bl2, (Map)object5);
        Iterable $this$forEach$iv = GenerateClientKt.generateClient((GraphQLClientGeneratorConfig)config, (File)graphQLSchema, (List)targetQueryFiles2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileSpec it = (FileSpec)element$iv;
            boolean bl3 = false;
            it.writeTo(targetDirectory);
        }
        this.getLogger().debug("successfully generated GraphQL HTTP client");
    }

    /*
     * WARNING - void declaration
     */
    private final void logConfiguration(File schema, List<? extends File> queryFiles) {
        this.getLogger().debug("GraphQL Client generator configuration:");
        this.getLogger().debug("  schema file = " + schema.getPath());
        this.getLogger().debug("  queries");
        Iterable $this$forEach$iv = queryFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            this.getLogger().debug("    - " + it.getName());
        }
        this.getLogger().debug("  packageName = " + this.packageName);
        this.getLogger().debug("  allowDeprecatedFields = " + this.allowDeprecatedFields);
        this.getLogger().debug("  converters");
        $this$forEach$iv = ((Map)this.converters.get()).entrySet();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void customScalar;
            Map.Entry $dstr$customScalar$converterInfo = (Map.Entry)element$iv;
            boolean bl = false;
            Map.Entry entry = $dstr$customScalar$converterInfo;
            boolean bl2 = false;
            String string = (String)entry.getKey();
            entry = $dstr$customScalar$converterInfo;
            bl2 = false;
            ScalarConverterMapping converterInfo = (ScalarConverterMapping)entry.getValue();
            this.getLogger().debug("    - custom scalar = " + (String)customScalar);
            this.getLogger().debug("      |- type = " + converterInfo.getType());
            this.getLogger().debug("      |- converter = " + converterInfo.getConverter());
        }
        this.getLogger().debug("");
        this.getLogger().debug("-- end GraphQL Client generator configuration --");
    }

    public GraphQLGenerateClientTask() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Property property = project.getObjects().property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"project.objects.property(String::class.java)");
        this.schemaFileName = property;
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        RegularFileProperty regularFileProperty = project2.getObjects().fileProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)regularFileProperty, (String)"project.objects.fileProperty()");
        this.schemaFile = regularFileProperty;
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        Property property2 = project3.getObjects().property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property2, (String)"project.objects.property(String::class.java)");
        this.packageName = property2;
        Project project4 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
        Property property3 = project4.getObjects().property(Boolean.TYPE);
        Intrinsics.checkExpressionValueIsNotNull((Object)property3, (String)"project.objects.property(Boolean::class.java)");
        this.allowDeprecatedFields = property3;
        Project project5 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project5, (String)"project");
        MapProperty mapProperty = project5.getObjects().mapProperty(String.class, ScalarConverterMapping.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)mapProperty, (String)"project.objects.mapPrope\u2026erterMapping::class.java)");
        this.converters = mapProperty;
        Project project6 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project6, (String)"project");
        Property property4 = project6.getObjects().property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property4, (String)"project.objects.property(String::class.java)");
        this.queryFileDirectory = property4;
        Project project7 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project7, (String)"project");
        ConfigurableFileCollection configurableFileCollection = project7.getObjects().fileCollection();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"project.objects.fileCollection()");
        this.queryFiles = configurableFileCollection;
        Project project8 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project8, (String)"project");
        DirectoryProperty directoryProperty = project8.getObjects().directoryProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)directoryProperty, (String)"project.objects.directoryProperty()");
        this.outputDirectory = (Property)directoryProperty;
        this.setGroup("GraphQL");
        this.setDescription("Generate HTTP client from the specified GraphQL queries.");
        this.allowDeprecatedFields.convention((Object)false);
        this.converters.convention(MapsKt.emptyMap());
    }
}

