/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.sdk.core.client;

import com.expediagroup.sdk.core.client.ClientKt;
import com.expediagroup.sdk.core.client.DefaultEnvironmentProvider;
import com.expediagroup.sdk.core.client.DefaultHttpHandler;
import com.expediagroup.sdk.core.client.EnvironmentProvider;
import com.expediagroup.sdk.core.configuration.Credentials;
import com.expediagroup.sdk.core.configuration.provider.ConfigurationProvider;
import com.expediagroup.sdk.core.constant.Constant;
import com.expediagroup.sdk.core.constant.provider.ExceptionMessageProvider;
import com.expediagroup.sdk.core.constant.provider.LoggingMessageProvider;
import com.expediagroup.sdk.core.contract.Contract;
import com.expediagroup.sdk.core.contract.ContractKt;
import com.expediagroup.sdk.core.model.HeadersKt;
import com.expediagroup.sdk.core.model.exception.client.ExpediaGroupConfigurationException;
import com.expediagroup.sdk.core.plugin.HookContext;
import com.expediagroup.sdk.core.plugin.HookKt;
import com.expediagroup.sdk.core.plugin.Plugin;
import com.expediagroup.sdk.core.plugin.PluginConfiguration;
import com.expediagroup.sdk.core.plugin.PluginContext;
import com.expediagroup.sdk.core.plugin.PluginKt;
import com.expediagroup.sdk.core.plugin.authentication.AuthenticationConfiguration;
import com.expediagroup.sdk.core.plugin.authentication.AuthenticationHookFactory;
import com.expediagroup.sdk.core.plugin.authentication.AuthenticationPlugin;
import com.expediagroup.sdk.core.plugin.authentication.strategy.AuthenticationStrategy;
import com.expediagroup.sdk.core.plugin.encoding.EncodingConfiguration;
import com.expediagroup.sdk.core.plugin.encoding.EncodingPlugin;
import com.expediagroup.sdk.core.plugin.exception.ExceptionHandlingConfiguration;
import com.expediagroup.sdk.core.plugin.exception.ExceptionHandlingPlugin;
import com.expediagroup.sdk.core.plugin.httptimeout.HttpTimeoutConfiguration;
import com.expediagroup.sdk.core.plugin.httptimeout.HttpTimeoutPlugin;
import com.expediagroup.sdk.core.plugin.logging.ExpediaGroupLogger;
import com.expediagroup.sdk.core.plugin.logging.ExpediaGroupLoggerFactory;
import com.expediagroup.sdk.core.plugin.logging.LoggingConfiguration;
import com.expediagroup.sdk.core.plugin.logging.LoggingPlugin;
import com.expediagroup.sdk.core.plugin.request.DefaultRequestConfiguration;
import com.expediagroup.sdk.core.plugin.request.DefaultRequestPlugin;
import com.expediagroup.sdk.core.plugin.serialization.SerializationConfiguration;
import com.expediagroup.sdk.core.plugin.serialization.SerializationPlugin;
import io.ktor.client.HttpClient;
import io.ktor.client.HttpClientConfig;
import io.ktor.client.HttpClientKt;
import io.ktor.client.engine.HttpClientEngine;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpResponseKt;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 (2\u00020\u0001:\u0002'(B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J'\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0003H\u0086@\u00a2\u0006\u0002\u0010\u001fJ\u001e\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u0003H\u0086@\u00a2\u0006\u0002\u0010#J\u001e\u0010$\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u0003H\u00a6@\u00a2\u0006\u0002\u0010#J\r\u0010%\u001a\u00020!*\u00020&H\u0096\u0001R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/expediagroup/sdk/core/client/Client;", "Lcom/expediagroup/sdk/core/client/EnvironmentProvider;", "namespace", "", "environmentProvider", "(Ljava/lang/String;Lcom/expediagroup/sdk/core/client/EnvironmentProvider;)V", "configurationProvider", "Lcom/expediagroup/sdk/core/configuration/provider/ConfigurationProvider;", "getConfigurationProvider", "()Lcom/expediagroup/sdk/core/configuration/provider/ConfigurationProvider;", "httpClient", "Lio/ktor/client/HttpClient;", "getHttpClient", "()Lio/ktor/client/HttpClient;", "httpHandler", "Lcom/expediagroup/sdk/core/client/DefaultHttpHandler;", "buildHttpClient", "authenticationType", "Lcom/expediagroup/sdk/core/plugin/authentication/strategy/AuthenticationStrategy$AuthenticationType;", "httpClientEngine", "Lio/ktor/client/engine/HttpClientEngine;", "buildHttpClient$rapid_sdk", "fireMissingConfigurationIssue", "", "configurationKey", "isNotSuccessfulResponse", "", "response", "Lio/ktor/client/statement/HttpResponse;", "performGet", "url", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "throwIfError", "", "operationId", "(Lio/ktor/client/statement/HttpResponse;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "throwServiceException", "appendHeaders", "Lio/ktor/client/request/HttpRequestBuilder;", "Builder", "Companion", "rapid-sdk"})
public abstract class Client
implements EnvironmentProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final /* synthetic */ EnvironmentProvider $$delegate_0;
    @NotNull
    private final DefaultHttpHandler httpHandler;
    @NotNull
    private static final ExpediaGroupLogger log = ExpediaGroupLoggerFactory.INSTANCE.getLogger(Companion.getClass());

    public Client(@NotNull String namespace, @NotNull EnvironmentProvider environmentProvider) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)environmentProvider, (String)"environmentProvider");
        this.$$delegate_0 = environmentProvider;
        this.httpHandler = new DefaultHttpHandler(environmentProvider);
    }

    public /* synthetic */ Client(String string, EnvironmentProvider environmentProvider, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            environmentProvider = new DefaultEnvironmentProvider(string);
        }
        this(string, environmentProvider);
    }

    @Override
    public void appendHeaders(@NotNull HttpRequestBuilder $this$appendHeaders) {
        Intrinsics.checkNotNullParameter((Object)$this$appendHeaders, (String)"<this>");
        this.$$delegate_0.appendHeaders($this$appendHeaders);
    }

    @NotNull
    public abstract ConfigurationProvider getConfigurationProvider();

    @NotNull
    public abstract HttpClient getHttpClient();

    @NotNull
    public final HttpClient buildHttpClient$rapid_sdk(@NotNull ConfigurationProvider configurationProvider, @NotNull AuthenticationStrategy.AuthenticationType authenticationType, @NotNull HttpClientEngine httpClientEngine) {
        Intrinsics.checkNotNullParameter((Object)configurationProvider, (String)"configurationProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)authenticationType), (String)"authenticationType");
        Intrinsics.checkNotNullParameter((Object)httpClientEngine, (String)"httpClientEngine");
        return HttpClientKt.HttpClient(httpClientEngine, (Function1)new Function1<HttpClientConfig<?>, Unit>(configurationProvider, this, authenticationType){
            final /* synthetic */ ConfigurationProvider $configurationProvider;
            final /* synthetic */ Client this$0;
            final /* synthetic */ AuthenticationStrategy.AuthenticationType $authenticationType;
            {
                this.$configurationProvider = $configurationProvider;
                this.this$0 = $receiver;
                this.$authenticationType = $authenticationType;
                super(1);
            }

            public final void invoke(@NotNull HttpClientConfig<?> $this$HttpClient) {
                Set set2;
                Set maskedLoggingHeaders2;
                Intrinsics.checkNotNullParameter($this$HttpClient, (String)"$this$HttpClient");
                HttpClientConfig<?> httpClientConfig = $this$HttpClient;
                String string = this.$configurationProvider.getKey();
                if (string == null) {
                    Client.access$fireMissingConfigurationIssue(this.this$0, "key");
                    throw new KotlinNothingValueException();
                }
                String key2 = string;
                String string2 = this.$configurationProvider.getSecret();
                if (string2 == null) {
                    Client.access$fireMissingConfigurationIssue(this.this$0, "secret");
                    throw new KotlinNothingValueException();
                }
                String secret2 = string2;
                String string3 = this.$configurationProvider.getEndpoint();
                if (string3 == null) {
                    Client.access$fireMissingConfigurationIssue(this.this$0, "endpoint");
                    throw new KotlinNothingValueException();
                }
                String endpoint2 = string3;
                String string4 = this.$configurationProvider.getAuthEndpoint();
                if (string4 == null) {
                    Client.access$fireMissingConfigurationIssue(this.this$0, "auth endpoint");
                    throw new KotlinNothingValueException();
                }
                String authEndpoint2 = string4;
                Long l = this.$configurationProvider.getRequestTimeout();
                if (l == null) {
                    Client.access$fireMissingConfigurationIssue(this.this$0, "request timeout in milliseconds");
                    throw new KotlinNothingValueException();
                }
                long requestTimeout2 = l;
                Long l2 = this.$configurationProvider.getConnectionTimeout();
                if (l2 == null) {
                    Client.access$fireMissingConfigurationIssue(this.this$0, "connection timeout in milliseconds");
                    throw new KotlinNothingValueException();
                }
                long connectionTimeout2 = l2;
                Long l3 = this.$configurationProvider.getSocketTimeout();
                if (l3 == null) {
                    Client.access$fireMissingConfigurationIssue(this.this$0, "socket timeout in milliseconds");
                    throw new KotlinNothingValueException();
                }
                long socketTimeout2 = l3;
                Set set3 = this.$configurationProvider.getMaskedLoggingHeaders();
                if (set3 == null) {
                    set3 = maskedLoggingHeaders2 = SetsKt.emptySet();
                }
                if ((set2 = this.$configurationProvider.getMaskedLoggingBodyFields()) == null) {
                    set2 = SetsKt.emptySet();
                }
                Set maskedLoggingBodyFields2 = set2;
                AuthenticationConfiguration authenticationConfiguration = AuthenticationConfiguration.Companion.from(httpClientConfig, Credentials.Factory.from(key2, secret2), authEndpoint2, this.$authenticationType);
                PluginKt.plugins(this.this$0, (Function1<? super PluginContext, Unit>)((Function1)new Function1<PluginContext, Unit>(httpClientConfig, (Set<String>)maskedLoggingHeaders2, (Set<String>)maskedLoggingBodyFields2, authenticationConfiguration, endpoint2, requestTimeout2, connectionTimeout2, socketTimeout2){
                    final /* synthetic */ HttpClientConfig<?> $httpClientConfig;
                    final /* synthetic */ Set<String> $maskedLoggingHeaders;
                    final /* synthetic */ Set<String> $maskedLoggingBodyFields;
                    final /* synthetic */ AuthenticationConfiguration $authenticationConfiguration;
                    final /* synthetic */ String $endpoint;
                    final /* synthetic */ long $requestTimeout;
                    final /* synthetic */ long $connectionTimeout;
                    final /* synthetic */ long $socketTimeout;
                    {
                        this.$httpClientConfig = $httpClientConfig;
                        this.$maskedLoggingHeaders = $maskedLoggingHeaders;
                        this.$maskedLoggingBodyFields = $maskedLoggingBodyFields;
                        this.$authenticationConfiguration = $authenticationConfiguration;
                        this.$endpoint = $endpoint;
                        this.$requestTimeout = $requestTimeout;
                        this.$connectionTimeout = $connectionTimeout;
                        this.$socketTimeout = $socketTimeout;
                        super(1);
                    }

                    public final void invoke(@NotNull PluginContext $this$plugins) {
                        Intrinsics.checkNotNullParameter((Object)$this$plugins, (String)"$this$plugins");
                        $this$plugins.with($this$plugins.use((Plugin)LoggingPlugin.INSTANCE), (PluginConfiguration)LoggingConfiguration.Companion.from(this.$httpClientConfig, this.$maskedLoggingHeaders, this.$maskedLoggingBodyFields));
                        $this$plugins.with($this$plugins.use((Plugin)SerializationPlugin.INSTANCE), (PluginConfiguration)SerializationConfiguration.Companion.from(this.$httpClientConfig));
                        $this$plugins.with($this$plugins.use((Plugin)AuthenticationPlugin.INSTANCE), (PluginConfiguration)this.$authenticationConfiguration);
                        $this$plugins.with($this$plugins.use((Plugin)DefaultRequestPlugin.INSTANCE), (PluginConfiguration)DefaultRequestConfiguration.Companion.from(this.$httpClientConfig, this.$endpoint));
                        $this$plugins.with($this$plugins.use((Plugin)EncodingPlugin.INSTANCE), (PluginConfiguration)EncodingConfiguration.Companion.from(this.$httpClientConfig));
                        $this$plugins.with($this$plugins.use((Plugin)HttpTimeoutPlugin.INSTANCE), (PluginConfiguration)HttpTimeoutConfiguration.Companion.from(this.$httpClientConfig, this.$requestTimeout, this.$connectionTimeout, this.$socketTimeout));
                        $this$plugins.with($this$plugins.use((Plugin)ExceptionHandlingPlugin.INSTANCE), (PluginConfiguration)ExceptionHandlingConfiguration.Companion.from(this.$httpClientConfig));
                    }
                }));
                HookKt.hooks(this.this$0, (Function1<? super HookContext, Unit>)((Function1)new Function1<HookContext, Unit>(authenticationConfiguration){
                    final /* synthetic */ AuthenticationConfiguration $authenticationConfiguration;
                    {
                        this.$authenticationConfiguration = $authenticationConfiguration;
                        super(1);
                    }

                    public final void invoke(@NotNull HookContext $this$hooks) {
                        Intrinsics.checkNotNullParameter((Object)$this$hooks, (String)"$this$hooks");
                        $this$hooks.with($this$hooks.use(AuthenticationHookFactory.INSTANCE), (PluginConfiguration)this.$authenticationConfiguration);
                    }
                }));
            }
        });
    }

    public static /* synthetic */ HttpClient buildHttpClient$rapid_sdk$default(Client client, ConfigurationProvider configurationProvider, AuthenticationStrategy.AuthenticationType authenticationType, HttpClientEngine httpClientEngine, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildHttpClient");
        }
        if ((n & 4) != 0) {
            httpClientEngine = ClientKt.getDEFAULT_HTTP_CLIENT_ENGINE();
        }
        return client.buildHttpClient$rapid_sdk(configurationProvider, authenticationType, httpClientEngine);
    }

    private final Void fireMissingConfigurationIssue(String configurationKey) {
        throw new ExpediaGroupConfigurationException(ExceptionMessageProvider.INSTANCE.getMissingRequiredConfigurationMessage(configurationKey), null, 2, null);
    }

    private final boolean isNotSuccessfulResponse(HttpResponse response2) {
        IntRange intRange = Constant.INSTANCE.getSUCCESSFUL_STATUS_CODES_RANGE();
        int n = intRange.getFirst();
        int n2 = intRange.getLast();
        int n3 = response2.getStatus().getValue();
        return !(n <= n3 ? n3 <= n2 : false);
    }

    @Nullable
    public final Object throwIfError(@NotNull HttpResponse response2, @NotNull String operationId, @NotNull Continuation<? super Unit> $completion) {
        if (this.isNotSuccessfulResponse(response2)) {
            log.info(LoggingMessageProvider.INSTANCE.getResponseUnsuccessfulMessage(response2.getStatus(), HeadersKt.getTransactionId(HttpResponseKt.getRequest(response2).getHeaders())));
            Object object = this.throwServiceException(response2, operationId, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public abstract Object throwServiceException(@NotNull HttpResponse var1, @NotNull String var2, @NotNull Continuation<? super Unit> var3);

    @Nullable
    public final Object performGet(@NotNull String url2, @NotNull Continuation<? super HttpResponse> $completion) {
        return this.httpHandler.performGet(this.getHttpClient(), url2, $completion);
    }

    public static final /* synthetic */ Void access$fireMissingConfigurationIssue(Client $this, String configurationKey) {
        return $this.fireMissingConfigurationIssue(configurationKey);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0005\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010&\u001a\u00020'H&J\u0013\u0010\u0004\u001a\u00028\u00002\u0006\u0010(\u001a\u00020\u0005\u00a2\u0006\u0002\u0010)J\u0013\u0010\u000b\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010*J\u0013\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\f\u00a2\u0006\u0002\u0010*J\u001f\u0010\u0014\u001a\u00028\u00002\u0012\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0,\"\u00020\f\u00a2\u0006\u0002\u0010-J\u001f\u0010\u001a\u001a\u00028\u00002\u0012\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0,\"\u00020\f\u00a2\u0006\u0002\u0010-J\u0013\u0010\u001d\u001a\u00028\u00002\u0006\u0010(\u001a\u00020\u0005\u00a2\u0006\u0002\u0010)J\u0013\u0010 \u001a\u00028\u00002\u0006\u0010 \u001a\u00020\f\u00a2\u0006\u0002\u0010*J\r\u0010/\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u00100J\u0013\u0010#\u001a\u00028\u00002\u0006\u0010(\u001a\u00020\u0005\u00a2\u0006\u0002\u0010)R\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\n\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\"\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\"\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u001e\u0010\u001d\u001a\u0004\u0018\u00010\u0005X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\n\u001a\u0004\b\u001e\u0010\u0007\"\u0004\b\u001f\u0010\tR\u001c\u0010 \u001a\u0004\u0018\u00010\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u000e\"\u0004\b\"\u0010\u0010R\u001e\u0010#\u001a\u0004\u0018\u00010\u0005X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\n\u001a\u0004\b$\u0010\u0007\"\u0004\b%\u0010\t\u00a8\u00061"}, d2={"Lcom/expediagroup/sdk/core/client/Client$Builder;", "SELF", "", "()V", "connectionTimeout", "", "getConnectionTimeout", "()Ljava/lang/Long;", "setConnectionTimeout", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "endpoint", "", "getEndpoint", "()Ljava/lang/String;", "setEndpoint", "(Ljava/lang/String;)V", "key", "getKey", "setKey", "maskedLoggingBodyFields", "", "getMaskedLoggingBodyFields", "()Ljava/util/Set;", "setMaskedLoggingBodyFields", "(Ljava/util/Set;)V", "maskedLoggingHeaders", "getMaskedLoggingHeaders", "setMaskedLoggingHeaders", "requestTimeout", "getRequestTimeout", "setRequestTimeout", "secret", "getSecret", "setSecret", "socketTimeout", "getSocketTimeout", "setSocketTimeout", "build", "Lcom/expediagroup/sdk/core/client/Client;", "milliseconds", "(J)Lcom/expediagroup/sdk/core/client/Client$Builder;", "(Ljava/lang/String;)Lcom/expediagroup/sdk/core/client/Client$Builder;", "fields", "", "([Ljava/lang/String;)Lcom/expediagroup/sdk/core/client/Client$Builder;", "headers", "self", "()Lcom/expediagroup/sdk/core/client/Client$Builder;", "rapid-sdk"})
    public static abstract class Builder<SELF extends Builder<SELF>> {
        @Nullable
        private String key;
        @Nullable
        private String secret;
        @Nullable
        private String endpoint;
        @Nullable
        private Long requestTimeout;
        @Nullable
        private Long connectionTimeout;
        @Nullable
        private Long socketTimeout;
        @Nullable
        private Set<String> maskedLoggingHeaders;
        @Nullable
        private Set<String> maskedLoggingBodyFields;

        @Nullable
        protected final String getKey() {
            return this.key;
        }

        protected final void setKey(@Nullable String string) {
            this.key = string;
        }

        @Nullable
        protected final String getSecret() {
            return this.secret;
        }

        protected final void setSecret(@Nullable String string) {
            this.secret = string;
        }

        @Nullable
        protected final String getEndpoint() {
            return this.endpoint;
        }

        protected final void setEndpoint(@Nullable String string) {
            this.endpoint = string;
        }

        @Nullable
        protected final Long getRequestTimeout() {
            return this.requestTimeout;
        }

        protected final void setRequestTimeout(@Nullable Long l) {
            this.requestTimeout = l;
        }

        @Nullable
        protected final Long getConnectionTimeout() {
            return this.connectionTimeout;
        }

        protected final void setConnectionTimeout(@Nullable Long l) {
            this.connectionTimeout = l;
        }

        @Nullable
        protected final Long getSocketTimeout() {
            return this.socketTimeout;
        }

        protected final void setSocketTimeout(@Nullable Long l) {
            this.socketTimeout = l;
        }

        @Nullable
        protected final Set<String> getMaskedLoggingHeaders() {
            return this.maskedLoggingHeaders;
        }

        protected final void setMaskedLoggingHeaders(@Nullable Set<String> set2) {
            this.maskedLoggingHeaders = set2;
        }

        @Nullable
        protected final Set<String> getMaskedLoggingBodyFields() {
            return this.maskedLoggingBodyFields;
        }

        protected final void setMaskedLoggingBodyFields(@Nullable Set<String> set2) {
            this.maskedLoggingBodyFields = set2;
        }

        @NotNull
        public final SELF key(@NotNull String key2) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            this.key = key2;
            return this.self();
        }

        @NotNull
        public final SELF secret(@NotNull String secret2) {
            Intrinsics.checkNotNullParameter((Object)secret2, (String)"secret");
            this.secret = secret2;
            return this.self();
        }

        @NotNull
        public final SELF endpoint(@NotNull String endpoint2) {
            Intrinsics.checkNotNullParameter((Object)endpoint2, (String)"endpoint");
            this.endpoint = ContractKt.adhereTo(endpoint2, Contract.TRAILING_SLASH);
            log.info(LoggingMessageProvider.INSTANCE.getRuntimeConfigurationProviderMessage("endpoint", endpoint2));
            return this.self();
        }

        @NotNull
        public final SELF requestTimeout(long milliseconds) {
            this.requestTimeout = milliseconds;
            log.info(LoggingMessageProvider.INSTANCE.getRuntimeConfigurationProviderMessage("request timeout in milliseconds", String.valueOf(milliseconds)));
            return this.self();
        }

        @NotNull
        public final SELF connectionTimeout(long milliseconds) {
            this.connectionTimeout = milliseconds;
            log.info(LoggingMessageProvider.INSTANCE.getRuntimeConfigurationProviderMessage("connection timeout in milliseconds", String.valueOf(milliseconds)));
            return this.self();
        }

        @NotNull
        public final SELF socketTimeout(long milliseconds) {
            this.socketTimeout = milliseconds;
            log.info(LoggingMessageProvider.INSTANCE.getRuntimeConfigurationProviderMessage("socket timeout in milliseconds", String.valueOf(milliseconds)));
            return this.self();
        }

        @NotNull
        public final SELF maskedLoggingHeaders(String ... headers) {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            this.maskedLoggingHeaders = ArraysKt.toSet((Object[])headers);
            log.info(LoggingMessageProvider.INSTANCE.getRuntimeConfigurationProviderMessage("masked logging headers", ArraysKt.joinToString$default((Object[])headers, null, null, null, (int)0, null, null, (int)63, null)));
            return this.self();
        }

        @NotNull
        public final SELF maskedLoggingBodyFields(String ... fields) {
            Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
            this.maskedLoggingBodyFields = ArraysKt.toSet((Object[])fields);
            log.info(LoggingMessageProvider.INSTANCE.getRuntimeConfigurationProviderMessage("masked logging body fields", ArraysKt.joinToString$default((Object[])fields, null, null, null, (int)0, null, null, (int)63, null)));
            return this.self();
        }

        @NotNull
        public abstract Client build();

        @NotNull
        protected SELF self() {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type SELF of com.expediagroup.sdk.core.client.Client.Builder");
            return (SELF)this;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/expediagroup/sdk/core/client/Client$Companion;", "", "()V", "log", "Lcom/expediagroup/sdk/core/plugin/logging/ExpediaGroupLogger;", "rapid-sdk"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

