/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.sdk.core.client;

import com.expediagroup.sdk.core.plugin.logging.ExpediaGroupLogger;
import com.expediagroup.sdk.core.plugin.logging.ExpediaGroupLoggerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J*\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J2\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010 \u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010$\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010%\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010&\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010'\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010+\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u0010\u0010.\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010/\u001a\u0004\u0018\u000100*\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/expediagroup/sdk/core/client/OkHttpEventListener;", "Lokhttp3/EventListener;", "()V", "log", "Lcom/expediagroup/sdk/core/plugin/logging/ExpediaGroupLogger;", "callEnd", "", "call", "Lokhttp3/Call;", "callFailed", "ioe", "Ljava/io/IOException;", "callStart", "canceled", "connectEnd", "inetSocketAddress", "Ljava/net/InetSocketAddress;", "proxy", "Ljava/net/Proxy;", "protocol", "Lokhttp3/Protocol;", "connectFailed", "connectStart", "connectionAcquired", "connection", "Lokhttp3/Connection;", "connectionReleased", "requestBodyEnd", "byteCount", "", "requestBodyStart", "requestFailed", "requestHeadersEnd", "request", "Lokhttp3/Request;", "requestHeadersStart", "responseBodyEnd", "responseBodyStart", "responseFailed", "responseHeadersEnd", "response", "Lokhttp3/Response;", "responseHeadersStart", "secureConnectEnd", "handshake", "Lokhttp3/Handshake;", "secureConnectStart", "getTransactionId", "", "rapid-sdk"})
public final class OkHttpEventListener
extends EventListener {
    @NotNull
    public static final OkHttpEventListener INSTANCE = new OkHttpEventListener();
    @NotNull
    private static final ExpediaGroupLogger log = ExpediaGroupLoggerFactory.INSTANCE.getLogger(INSTANCE.getClass());

    private OkHttpEventListener() {
    }

    @Nullable
    public final String getTransactionId(@NotNull Call $this$getTransactionId) {
        Intrinsics.checkNotNullParameter((Object)$this$getTransactionId, (String)"<this>");
        return $this$getTransactionId.request().headers().get("transaction-id");
    }

    @Override
    public void callStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.callStart(call);
        log.debug("Call start for transaction-id: [" + this.getTransactionId(call) + ']');
    }

    @Override
    public void callEnd(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.callEnd(call);
        log.debug("Call end for transaction-id: [" + this.getTransactionId(call) + ']');
    }

    @Override
    public void callFailed(@NotNull Call call, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        super.callFailed(call, ioe);
        log.debug("Call failed for transaction-id: [" + this.getTransactionId(call) + "] with exception message: " + ioe.getMessage());
    }

    @Override
    public void canceled(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.canceled(call);
        log.debug("Call canceled for transaction-id: [" + this.getTransactionId(call) + ']');
    }

    @Override
    public void connectStart(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        super.connectStart(call, inetSocketAddress, proxy);
        log.debug("Connect start for transaction-id: [" + this.getTransactionId(call) + ']');
    }

    @Override
    public void connectEnd(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy, @Nullable Protocol protocol) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        super.connectEnd(call, inetSocketAddress, proxy, protocol);
        log.debug("Connect end for transaction-id: [" + this.getTransactionId(call) + ']');
    }

    @Override
    public void connectFailed(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy, @Nullable Protocol protocol, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        super.connectFailed(call, inetSocketAddress, proxy, protocol, ioe);
        log.debug("Connect failed for transaction-id: [" + this.getTransactionId(call) + "] with exception message: " + ioe.getMessage());
    }

    @Override
    public void connectionAcquired(@NotNull Call call, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        super.connectionAcquired(call, connection);
        log.debug("Connection acquired for transaction-id: [" + this.getTransactionId(call) + ']');
    }

    @Override
    public void connectionReleased(@NotNull Call call, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        super.connectionReleased(call, connection);
        log.debug("Connection released for transaction-id: [" + this.getTransactionId(call) + ']');
    }

    @Override
    public void secureConnectStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.secureConnectStart(call);
        log.debug("Secure connect start for transaction-id: [" + this.getTransactionId(call) + ']');
    }

    @Override
    public void secureConnectEnd(@NotNull Call call, @Nullable Handshake handshake2) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.secureConnectEnd(call, handshake2);
        log.debug("Secure connect end for transaction-id: [" + this.getTransactionId(call) + ']');
    }

    @Override
    public void requestHeadersStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.requestHeadersStart(call);
        log.debug("Sending request headers start for transaction-id: [" + this.getTransactionId(call) + ']');
    }

    @Override
    public void requestHeadersEnd(@NotNull Call call, @NotNull Request request2) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        super.requestHeadersEnd(call, request2);
        log.debug("Sending request headers end for transaction-id: [" + this.getTransactionId(call) + ']');
    }

    @Override
    public void requestBodyStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.requestBodyStart(call);
        log.debug("Sending request body start for transaction-id: [" + this.getTransactionId(call) + ']');
    }

    @Override
    public void requestBodyEnd(@NotNull Call call, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.requestBodyEnd(call, byteCount);
        log.debug("Sending request body end for transaction-id: [" + this.getTransactionId(call) + "] with byte count: " + byteCount);
    }

    @Override
    public void requestFailed(@NotNull Call call, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        super.requestFailed(call, ioe);
        log.debug("Request failed for transaction-id: [" + this.getTransactionId(call) + "] with exception message: " + ioe.getMessage());
    }

    @Override
    public void responseHeadersStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.responseHeadersStart(call);
        log.debug("Receiving response headers start for transaction-id: [" + this.getTransactionId(call) + ']');
    }

    @Override
    public void responseHeadersEnd(@NotNull Call call, @NotNull Response response2) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        super.responseHeadersEnd(call, response2);
        log.debug("Receiving response headers end for transaction-id: [" + this.getTransactionId(call) + ']');
    }

    @Override
    public void responseBodyStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.responseBodyStart(call);
        log.debug("Receiving response body start for transaction-id: [" + this.getTransactionId(call) + ']');
    }

    @Override
    public void responseBodyEnd(@NotNull Call call, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.responseBodyEnd(call, byteCount);
        log.debug("Receiving response body end for transaction-id: [" + this.getTransactionId(call) + "] with byte count: " + byteCount);
    }

    @Override
    public void responseFailed(@NotNull Call call, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        super.responseFailed(call, ioe);
        log.debug("Receiving response failed for transaction-id: [" + this.getTransactionId(call) + "] with exception message: " + ioe.getMessage());
    }
}

