/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.constraintvalidators.hv;

import com.expediagroup.sdk.dependencies.org.hibernate.validator.constraints.UniqueElements;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorContext;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.util.CollectionHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class UniqueElementsValidator
implements ConstraintValidator<UniqueElements, Collection> {
    @Override
    public boolean isValid(Collection collection, ConstraintValidatorContext constraintValidatorContext) {
        if (collection == null || collection.size() < 2) {
            return true;
        }
        List<Object> duplicates = this.findDuplicates(collection);
        if (duplicates.isEmpty()) {
            return true;
        }
        if (constraintValidatorContext instanceof HibernateConstraintValidatorContext) {
            constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class).addMessageParameter("duplicates", duplicates.stream().map(String::valueOf).collect(Collectors.joining(", "))).withDynamicPayload(CollectionHelper.toImmutableList(duplicates));
        }
        return false;
    }

    private List<Object> findDuplicates(Collection<?> collection) {
        HashSet uniqueElements = CollectionHelper.newHashSet(collection.size());
        return collection.stream().filter(o -> !uniqueElements.add(o)).collect(Collectors.toList());
    }
}

