/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.constraintvalidators.hv.pl;

import com.expediagroup.sdk.dependencies.org.hibernate.validator.constraints.pl.PESEL;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.constraintvalidators.hv.ModCheckBase;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.util.ModUtil;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import javax.validation.ConstraintValidator;

public class PESELValidator
extends ModCheckBase
implements ConstraintValidator<PESEL, CharSequence> {
    private static final int[] WEIGHTS_PESEL = new int[]{1, 3, 7, 9, 1, 3, 7, 9, 1, 3};

    @Override
    public void initialize(PESEL constraintAnnotation) {
        super.initialize(0, Integer.MAX_VALUE, -1, false);
    }

    @Override
    public boolean isCheckDigitValid(List<Integer> digits, char checkDigit) {
        if (digits.size() != WEIGHTS_PESEL.length) {
            return false;
        }
        int monthCode = this.doubleDigitNumberFromSubList(digits, 2);
        try {
            LocalDate.of(this.year(this.doubleDigitNumberFromSubList(digits, 0), monthCode / 20), monthCode % 20, this.doubleDigitNumberFromSubList(digits, 4));
        }
        catch (DateTimeException e) {
            return false;
        }
        Collections.reverse(digits);
        int modResult = ModUtil.calculateModXCheckWithWeights(digits, 10, Integer.MAX_VALUE, WEIGHTS_PESEL);
        switch (modResult) {
            case 10: {
                return checkDigit == '0';
            }
        }
        return Character.isDigit(checkDigit) && modResult == this.extractDigit(checkDigit);
    }

    private int doubleDigitNumberFromSubList(List<Integer> digits, int start) {
        return digits.get(start) * 10 + digits.get(start + 1);
    }

    private int year(int year2, int centuryCode) {
        switch (centuryCode) {
            case 4: {
                return 1800 + year2;
            }
            case 0: {
                return 1900 + year2;
            }
            case 1: {
                return 2000 + year2;
            }
            case 2: {
                return 2100 + year2;
            }
            case 3: {
                return 2200 + year2;
            }
        }
        throw new IllegalStateException("Invalid century code.");
    }
}

