/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.engine.messageinterpolation.parser;

import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.engine.messageinterpolation.InterpolationTermType;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.engine.messageinterpolation.parser.ELState;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.engine.messageinterpolation.parser.EscapedState;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.engine.messageinterpolation.parser.InterpolationTermState;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.engine.messageinterpolation.parser.MessageDescriptorFormatException;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.engine.messageinterpolation.parser.ParserState;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.engine.messageinterpolation.parser.TokenCollector;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.util.logging.Log;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.util.logging.LoggerFactory;
import java.lang.invoke.MethodHandles;

public class MessageState
implements ParserState {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());

    @Override
    public void terminate(TokenCollector tokenCollector) throws MessageDescriptorFormatException {
        tokenCollector.terminateToken();
    }

    @Override
    public void handleNonMetaCharacter(char character, TokenCollector tokenCollector) throws MessageDescriptorFormatException {
        tokenCollector.appendToToken(character);
    }

    @Override
    public void handleBeginTerm(char character, TokenCollector tokenCollector) throws MessageDescriptorFormatException {
        tokenCollector.terminateToken();
        tokenCollector.appendToToken(character);
        if (tokenCollector.getInterpolationType().equals((Object)InterpolationTermType.PARAMETER)) {
            tokenCollector.makeParameterToken();
        }
        tokenCollector.transitionState(new InterpolationTermState());
    }

    @Override
    public void handleEndTerm(char character, TokenCollector tokenCollector) throws MessageDescriptorFormatException {
        throw LOG.getUnbalancedBeginEndParameterException(tokenCollector.getOriginalMessageDescriptor(), character);
    }

    @Override
    public void handleEscapeCharacter(char character, TokenCollector tokenCollector) throws MessageDescriptorFormatException {
        tokenCollector.appendToToken(character);
        tokenCollector.transitionState(new EscapedState(this));
    }

    @Override
    public void handleELDesignator(char character, TokenCollector tokenCollector) throws MessageDescriptorFormatException {
        if (tokenCollector.getInterpolationType().equals((Object)InterpolationTermType.PARAMETER)) {
            this.handleNonMetaCharacter(character, tokenCollector);
        } else {
            tokenCollector.transitionState(new ELState());
        }
    }
}

