/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.engine.valueextraction;

import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.IgnoreForbiddenApisErrors;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.engine.valueextraction.ValueExtractorDescriptor;
import java.util.Map;
import java.util.Optional;
import javafx.beans.property.ReadOnlyMapProperty;
import javax.validation.valueextraction.ValueExtractor;

@IgnoreForbiddenApisErrors(reason="Usage of JavaFX classes")
class ReadOnlyMapPropertyKeyExtractor
implements ValueExtractor<ReadOnlyMapProperty<?, ?>> {
    static final ValueExtractorDescriptor DESCRIPTOR = new ValueExtractorDescriptor(new ReadOnlyMapPropertyKeyExtractor(), ReadOnlyMapProperty.class, ReadOnlyMapProperty.class.getTypeParameters()[0], false, Optional.empty());

    private ReadOnlyMapPropertyKeyExtractor() {
    }

    @Override
    public void extractValues(ReadOnlyMapProperty<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
        for (Map.Entry entry : originalValue.entrySet()) {
            receiver.keyedValue("<map key>", entry.getKey(), entry.getKey());
        }
    }
}

