/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.engine.valueextraction;

import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.engine.valueextraction.ValueExtractorDescriptor;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.util.logging.Log;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.util.logging.LoggerFactory;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import javax.validation.valueextraction.ValueExtractor;

public class ValueExtractorHelper {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());

    private ValueExtractorHelper() {
    }

    public static Set<Class<? extends ValueExtractor>> toValueExtractorClasses(Set<ValueExtractorDescriptor> valueExtractorDescriptors) {
        return valueExtractorDescriptors.stream().map(valueExtractorDescriptor -> valueExtractorDescriptor.getValueExtractor().getClass()).collect(Collectors.toSet());
    }

    public static void extractValues(ValueExtractorDescriptor valueExtractorDescriptor, Object containerValue, ValueExtractor.ValueReceiver valueReceiver) {
        ValueExtractor<?> valueExtractor = valueExtractorDescriptor.getValueExtractor();
        try {
            valueExtractor.extractValues(containerValue, valueReceiver);
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw LOG.getErrorWhileExtractingValuesInValueExtractorException(valueExtractor.getClass(), e);
        }
    }
}

