/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.metadata;

import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.engine.ConstraintCreationContext;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.engine.MethodValidationConfiguration;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.engine.groups.ValidationOrderGenerator;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.metadata.BeanMetaDataManager;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.metadata.aggregated.BeanMetaDataBuilder;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.metadata.aggregated.BeanMetaDataImpl;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptions;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptionsImpl;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.metadata.provider.AnnotationMetaDataProvider;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.metadata.provider.MetaDataProvider;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.metadata.raw.BeanConfiguration;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.properties.javabean.JavaBeanHelper;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.util.CollectionHelper;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.util.ConcurrentReferenceHashMap;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.util.Contracts;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.util.ExecutableHelper;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.util.ExecutableParameterNameProvider;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.util.classhierarchy.ClassHierarchyHelper;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.util.classhierarchy.Filter;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.util.logging.Messages;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.metadata.BeanMetaDataClassNormalizer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class BeanMetaDataManagerImpl
implements BeanMetaDataManager {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private final List<MetaDataProvider> metaDataProviders;
    private final ConstraintCreationContext constraintCreationContext;
    private final ExecutableParameterNameProvider parameterNameProvider;
    private final ConcurrentReferenceHashMap<Class<?>, BeanMetaData<?>> beanMetaDataCache;
    private final ExecutableHelper executableHelper;
    private final BeanMetaDataClassNormalizer beanMetaDataClassNormalizer;
    private final ValidationOrderGenerator validationOrderGenerator;
    private final MethodValidationConfiguration methodValidationConfiguration;

    public BeanMetaDataManagerImpl(ConstraintCreationContext constraintCreationContext, ExecutableHelper executableHelper, ExecutableParameterNameProvider parameterNameProvider, JavaBeanHelper javaBeanHelper, BeanMetaDataClassNormalizer beanMetaDataClassNormalizer, ValidationOrderGenerator validationOrderGenerator, List<MetaDataProvider> optionalMetaDataProviders, MethodValidationConfiguration methodValidationConfiguration) {
        this.constraintCreationContext = constraintCreationContext;
        this.executableHelper = executableHelper;
        this.parameterNameProvider = parameterNameProvider;
        this.beanMetaDataClassNormalizer = beanMetaDataClassNormalizer;
        this.validationOrderGenerator = validationOrderGenerator;
        this.methodValidationConfiguration = methodValidationConfiguration;
        this.beanMetaDataCache = new ConcurrentReferenceHashMap(16, 0.75f, 16, ConcurrentReferenceHashMap.ReferenceType.SOFT, ConcurrentReferenceHashMap.ReferenceType.SOFT, EnumSet.of(ConcurrentReferenceHashMap.Option.IDENTITY_COMPARISONS));
        AnnotationProcessingOptions annotationProcessingOptions = this.getAnnotationProcessingOptionsFromNonDefaultProviders(optionalMetaDataProviders);
        AnnotationMetaDataProvider defaultProvider = new AnnotationMetaDataProvider(constraintCreationContext, javaBeanHelper, annotationProcessingOptions);
        ArrayList<MetaDataProvider> tmpMetaDataProviders = new ArrayList<MetaDataProvider>(optionalMetaDataProviders.size() + 1);
        tmpMetaDataProviders.add(defaultProvider);
        tmpMetaDataProviders.addAll(optionalMetaDataProviders);
        this.metaDataProviders = CollectionHelper.toImmutableList(tmpMetaDataProviders);
    }

    @Override
    public <T> BeanMetaData<T> getBeanMetaData(Class<T> beanClass) {
        Contracts.assertNotNull(beanClass, Messages.MESSAGES.beanTypeCannotBeNull());
        Class<T> normalizedBeanClass = this.beanMetaDataClassNormalizer.normalize(beanClass);
        BeanMetaData<?> beanMetaData = this.beanMetaDataCache.get(normalizedBeanClass);
        if (beanMetaData != null) {
            return beanMetaData;
        }
        beanMetaData = this.createBeanMetaData(normalizedBeanClass);
        BeanMetaData<?> previousBeanMetaData = this.beanMetaDataCache.putIfAbsent(normalizedBeanClass, beanMetaData);
        if (previousBeanMetaData != null) {
            return previousBeanMetaData;
        }
        return beanMetaData;
    }

    @Override
    public void clear() {
        this.beanMetaDataCache.clear();
    }

    public int numberOfCachedBeanMetaDataInstances() {
        return this.beanMetaDataCache.size();
    }

    private <T> BeanMetaDataImpl<T> createBeanMetaData(Class<T> clazz) {
        BeanMetaDataBuilder<T> builder = BeanMetaDataBuilder.getInstance(this.constraintCreationContext, this.executableHelper, this.parameterNameProvider, this.validationOrderGenerator, clazz, this.methodValidationConfiguration);
        for (MetaDataProvider provider2 : this.metaDataProviders) {
            for (BeanConfiguration<T> beanConfiguration : this.getBeanConfigurationForHierarchy(provider2, clazz)) {
                builder.add(beanConfiguration);
            }
        }
        return builder.build();
    }

    private AnnotationProcessingOptions getAnnotationProcessingOptionsFromNonDefaultProviders(List<MetaDataProvider> optionalMetaDataProviders) {
        AnnotationProcessingOptionsImpl options2 = new AnnotationProcessingOptionsImpl();
        for (MetaDataProvider metaDataProvider : optionalMetaDataProviders) {
            options2.merge(metaDataProvider.getAnnotationProcessingOptions());
        }
        return options2;
    }

    private <T> List<BeanConfiguration<? super T>> getBeanConfigurationForHierarchy(MetaDataProvider provider2, Class<T> beanClass) {
        ArrayList<BeanConfiguration<T>> configurations = CollectionHelper.newArrayList();
        for (Class<T> clazz : ClassHierarchyHelper.getHierarchy(beanClass, new Filter[0])) {
            BeanConfiguration<T> configuration = provider2.getBeanConfiguration(clazz);
            if (configuration == null) continue;
            configurations.add(configuration);
        }
        return configurations;
    }
}

