/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.sdk.dependencies.org.hibernate.validator.resourceloading;

import com.expediagroup.sdk.dependencies.org.hibernate.validator.resourceloading.DelegatingResourceBundleLocator;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CachingResourceBundleLocator
extends DelegatingResourceBundleLocator {
    private final ConcurrentMap<Locale, ResourceBundle> bundleCache = new ConcurrentHashMap<Locale, ResourceBundle>();

    public CachingResourceBundleLocator(ResourceBundleLocator delegate) {
        super(delegate);
    }

    @Override
    public ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundle bundle2;
        ResourceBundle cachedResourceBundle = (ResourceBundle)this.bundleCache.get(locale);
        if (cachedResourceBundle == null && (bundle2 = super.getResourceBundle(locale)) != null && (cachedResourceBundle = this.bundleCache.putIfAbsent(locale, bundle2)) == null) {
            return bundle2;
        }
        return cachedResourceBundle;
    }
}

