/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.sdk.rapid.models.exception;

import com.expediagroup.sdk.core.model.exception.service.ExpediaGroupApiException;
import io.ktor.client.statement.HttpResponse;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0010\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/expediagroup/sdk/rapid/models/exception/HttpStatusCodeRange;", "", "statusCode", "", "getException", "Lkotlin/Function1;", "Lio/ktor/client/statement/HttpResponse;", "Lcom/expediagroup/sdk/core/model/exception/service/ExpediaGroupApiException;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getGetException", "()Lkotlin/jvm/functions/Function1;", "compareTo", "", "other", "isRangeDefinition", "", "matches", "rapid-sdk"})
public class HttpStatusCodeRange
implements Comparable<HttpStatusCodeRange> {
    @NotNull
    private final String statusCode;
    @NotNull
    private final Function1<HttpResponse, ExpediaGroupApiException> getException;

    public HttpStatusCodeRange(@NotNull String statusCode, @NotNull Function1<? super HttpResponse, ? extends ExpediaGroupApiException> getException) {
        Intrinsics.checkNotNullParameter((Object)statusCode, (String)"statusCode");
        Intrinsics.checkNotNullParameter(getException, (String)"getException");
        this.statusCode = statusCode;
        this.getException = getException;
    }

    @NotNull
    public final Function1<HttpResponse, ExpediaGroupApiException> getGetException() {
        return this.getException;
    }

    public boolean matches(@NotNull String statusCode) {
        Intrinsics.checkNotNullParameter((Object)statusCode, (String)"statusCode");
        return this.isRangeDefinition() ? StringsKt.first((CharSequence)this.statusCode) == StringsKt.first((CharSequence)statusCode) : Intrinsics.areEqual((Object)this.statusCode, (Object)statusCode);
    }

    public boolean isRangeDefinition() {
        CharSequence charSequence = this.statusCode;
        return new Regex("^[1-5]XX$").matches(charSequence);
    }

    @Override
    public int compareTo(@NotNull HttpStatusCodeRange other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.compare((int)(this.isRangeDefinition() ? 1 : 0), (int)(other.isRangeDefinition() ? 1 : 0));
    }
}

