/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.plugins;

import io.ktor.client.engine.HttpClientEngineCapability;
import io.ktor.client.network.sockets.ConnectTimeoutException;
import io.ktor.client.network.sockets.SocketTimeoutException;
import io.ktor.client.plugins.HttpTimeout;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestData;
import io.ktor.client.utils.ExceptionUtilsJvmKt;
import io.ktor.util.InternalAPI;
import io.ktor.util.logging.KtorSimpleLoggerJvmKt;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a)\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\r\u001a\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0007\u001a\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u001a%\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016H\u0081\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017\u001a#\u0010\u000b\u001a\u00020\u0018*\u00020\u00192\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00180\u001a\u00a2\u0006\u0002\b\u001c\"\u0012\u0010\u0000\u001a\u00060\u0001j\u0002`\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001d"}, d2={"LOGGER", "Lorg/slf4j/Logger;", "Lio/ktor/util/logging/Logger;", "ConnectTimeoutException", "Lio/ktor/client/network/sockets/ConnectTimeoutException;", "request", "Lio/ktor/client/request/HttpRequestData;", "cause", "", "url", "", "timeout", "", "(Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Throwable;)Lio/ktor/client/network/sockets/ConnectTimeoutException;", "SocketTimeoutException", "Lio/ktor/client/network/sockets/SocketTimeoutException;", "convertLongTimeoutToIntWithInfiniteAsZero", "", "convertLongTimeoutToLongWithInfiniteAsZero", "unwrapRequestTimeoutException", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "", "Lio/ktor/client/request/HttpRequestBuilder;", "Lkotlin/Function1;", "Lio/ktor/client/plugins/HttpTimeout$HttpTimeoutCapabilityConfiguration;", "Lkotlin/ExtensionFunctionType;", "ktor-client-core"})
public final class HttpTimeoutKt {
    @NotNull
    private static final Logger LOGGER = KtorSimpleLoggerJvmKt.KtorSimpleLogger("io.ktor.client.plugins.HttpTimeout");

    public static final void timeout(@NotNull HttpRequestBuilder $this$timeout, @NotNull Function1<? super HttpTimeout.HttpTimeoutCapabilityConfiguration, Unit> block2) {
        Intrinsics.checkNotNullParameter((Object)$this$timeout, (String)"<this>");
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        HttpClientEngineCapability httpClientEngineCapability = HttpTimeout.Plugin;
        HttpTimeout.HttpTimeoutCapabilityConfiguration httpTimeoutCapabilityConfiguration = new HttpTimeout.HttpTimeoutCapabilityConfiguration(null, null, null, 7, null);
        block2.invoke((Object)httpTimeoutCapabilityConfiguration);
        $this$timeout.setCapability(httpClientEngineCapability, httpTimeoutCapabilityConfiguration);
    }

    @NotNull
    public static final ConnectTimeoutException ConnectTimeoutException(@NotNull HttpRequestData request2, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        StringBuilder stringBuilder = new StringBuilder().append("Connect timeout has expired [url=").append(request2.getUrl()).append(", connect_timeout=");
        Object object = (HttpTimeout.HttpTimeoutCapabilityConfiguration)request2.getCapabilityOrNull(HttpTimeout.Plugin);
        if (object == null || (object = ((HttpTimeout.HttpTimeoutCapabilityConfiguration)object).getConnectTimeoutMillis()) == null) {
            object = "unknown";
        }
        return new ConnectTimeoutException(stringBuilder.append(object).append(" ms]").toString(), cause);
    }

    public static /* synthetic */ ConnectTimeoutException ConnectTimeoutException$default(HttpRequestData httpRequestData, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        return HttpTimeoutKt.ConnectTimeoutException(httpRequestData, throwable);
    }

    @NotNull
    public static final ConnectTimeoutException ConnectTimeoutException(@NotNull String url2, @Nullable Long timeout2, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        StringBuilder stringBuilder = new StringBuilder().append("Connect timeout has expired [url=").append(url2).append(", connect_timeout=");
        Object object = timeout2;
        if (object == null) {
            object = "unknown";
        }
        return new ConnectTimeoutException(stringBuilder.append(object).append(" ms]").toString(), cause);
    }

    public static /* synthetic */ ConnectTimeoutException ConnectTimeoutException$default(String string, Long l, Throwable throwable, int n, Object object) {
        if ((n & 4) != 0) {
            throwable = null;
        }
        return HttpTimeoutKt.ConnectTimeoutException(string, l, throwable);
    }

    @NotNull
    public static final SocketTimeoutException SocketTimeoutException(@NotNull HttpRequestData request2, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        StringBuilder stringBuilder = new StringBuilder().append("Socket timeout has expired [url=").append(request2.getUrl()).append(", socket_timeout=");
        Object object = (HttpTimeout.HttpTimeoutCapabilityConfiguration)request2.getCapabilityOrNull(HttpTimeout.Plugin);
        if (object == null || (object = ((HttpTimeout.HttpTimeoutCapabilityConfiguration)object).getSocketTimeoutMillis()) == null) {
            object = "unknown";
        }
        return new SocketTimeoutException(stringBuilder.append(object).append("] ms").toString(), cause);
    }

    public static /* synthetic */ SocketTimeoutException SocketTimeoutException$default(HttpRequestData httpRequestData, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        return HttpTimeoutKt.SocketTimeoutException(httpRequestData, throwable);
    }

    @InternalAPI
    public static final int convertLongTimeoutToIntWithInfiniteAsZero(long timeout2) {
        return timeout2 == Long.MAX_VALUE ? 0 : (timeout2 < Integer.MIN_VALUE ? Integer.MIN_VALUE : (timeout2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)timeout2));
    }

    @InternalAPI
    public static final long convertLongTimeoutToLongWithInfiniteAsZero(long timeout2) {
        return timeout2 == Long.MAX_VALUE ? 0L : timeout2;
    }

    @PublishedApi
    public static final <T> T unwrapRequestTimeoutException(@NotNull Function0<? extends T> block2) {
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        boolean $i$f$unwrapRequestTimeoutException = false;
        try {
            return (T)block2.invoke();
        }
        catch (CancellationException cause) {
            throw ExceptionUtilsJvmKt.unwrapCancellationException(cause);
        }
    }

    public static final /* synthetic */ Logger access$getLOGGER$p() {
        return LOGGER;
    }
}

