/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.websocket;

import io.ktor.utils.io.charsets.EncodingKt;
import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.Input;
import io.ktor.utils.io.core.InputPrimitivesKt;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.OutputKt;
import io.ktor.websocket.CloseReason;
import io.ktor.websocket.Frame;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\u00a8\u0006\t"}, d2={"readBytes", "", "Lio/ktor/websocket/Frame;", "readReason", "Lio/ktor/websocket/CloseReason;", "Lio/ktor/websocket/Frame$Close;", "readText", "", "Lio/ktor/websocket/Frame$Text;", "ktor-websockets"})
@SourceDebugExtension(value={"SMAP\nFrameCommon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameCommon.kt\nio/ktor/websocket/FrameCommonKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Builder.kt\nio/ktor/utils/io/core/BuilderKt\n*L\n1#1,173:1\n1#2:174\n12#3,11:175\n12#3,11:186\n*S KotlinDebug\n*F\n+ 1 FrameCommon.kt\nio/ktor/websocket/FrameCommonKt\n*L\n142#1:175,11\n161#1:186,11\n*E\n"})
public final class FrameCommonKt {
    @NotNull
    public static final String readText(@NotNull Frame.Text $this$readText) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter((Object)$this$readText, (String)"<this>");
        if (!$this$readText.getFin()) {
            boolean $i$a$-require-FrameCommonKt$readText$22 = false;
            String $i$a$-require-FrameCommonKt$readText$22 = "Text could be only extracted from non-fragmented frame";
            throw new IllegalArgumentException($i$a$-require-FrameCommonKt$readText$22.toString());
        }
        CharsetDecoder charsetDecoder = Charsets.UTF_8.newDecoder();
        Intrinsics.checkNotNullExpressionValue((Object)charsetDecoder, (String)"UTF_8.newDecoder()");
        CharsetDecoder charsetDecoder2 = charsetDecoder;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$readText_u24lambda_u241 = builder$iv;
            boolean bl = false;
            OutputKt.writeFully$default((Output)$this$readText_u24lambda_u241, $this$readText.getData(), 0, 0, 6, null);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return EncodingKt.decode$default(charsetDecoder2, byteReadPacket, 0, 2, null);
    }

    @NotNull
    public static final byte[] readBytes(@NotNull Frame $this$readBytes) {
        Intrinsics.checkNotNullParameter((Object)$this$readBytes, (String)"<this>");
        byte[] byArray = $this$readBytes.getData();
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(this, size)");
        return byArray2;
    }

    @Nullable
    public static final CloseReason readReason(@NotNull Frame.Close $this$readReason) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter((Object)$this$readReason, (String)"<this>");
        if ($this$readReason.getData().length < 2) {
            return null;
        }
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$readReason_u24lambda_u242 = builder$iv;
            boolean bl = false;
            OutputKt.writeFully$default((Output)$this$readReason_u24lambda_u242, $this$readReason.getData(), 0, 0, 6, null);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket packet = byteReadPacket;
        short code = InputPrimitivesKt.readShort(packet);
        String message = Input.readText$default(packet, 0, 0, 3, null);
        return new CloseReason(code, message);
    }
}

