/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.LogManager;
import org.jboss.logging.JBossLogManagerProvider;
import org.jboss.logging.JDKLoggerProvider;
import org.jboss.logging.Log4j2LoggerProvider;
import org.jboss.logging.Log4jLoggerProvider;
import org.jboss.logging.Logger;
import org.jboss.logging.LoggerProvider;
import org.jboss.logging.SecurityActions;
import org.jboss.logging.Slf4jLoggerProvider;

final class LoggerProviders {
    static final String LOGGING_PROVIDER_KEY = "org.jboss.logging.provider";
    static final LoggerProvider PROVIDER = LoggerProviders.find();

    private static LoggerProvider find() {
        return LoggerProviders.findProvider();
    }

    private static LoggerProvider findProvider() {
        ClassLoader cl = LoggerProviders.class.getClassLoader();
        try {
            String loggerProvider = SecurityActions.getSystemProperty(LOGGING_PROVIDER_KEY);
            if (loggerProvider != null) {
                if ("jboss".equalsIgnoreCase(loggerProvider)) {
                    return LoggerProviders.tryJBossLogManager(cl, "system property");
                }
                if ("jdk".equalsIgnoreCase(loggerProvider)) {
                    return LoggerProviders.tryJDK("system property");
                }
                if ("log4j2".equalsIgnoreCase(loggerProvider)) {
                    return LoggerProviders.tryLog4j2(cl, "system property");
                }
                if ("log4j".equalsIgnoreCase(loggerProvider)) {
                    return LoggerProviders.tryLog4j(cl, "system property");
                }
                if ("slf4j".equalsIgnoreCase(loggerProvider)) {
                    return LoggerProviders.trySlf4j("system property");
                }
            }
        }
        catch (Throwable loggerProvider) {
            // empty catch block
        }
        try {
            ServiceLoader<LoggerProvider> loader = ServiceLoader.load(LoggerProvider.class, cl);
            Iterator<LoggerProvider> iter = loader.iterator();
            while (true) {
                try {
                    if (iter.hasNext()) {
                        LoggerProvider provider2 = iter.next();
                        LoggerProviders.logProvider(provider2, "service loader");
                        return provider2;
                    }
                }
                catch (ServiceConfigurationError serviceConfigurationError) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            return LoggerProviders.tryJBossLogManager(cl, null);
        }
        catch (Throwable throwable) {
            try {
                return LoggerProviders.tryLog4j2(cl, null);
            }
            catch (Throwable throwable2) {
                try {
                    return LoggerProviders.tryLog4j(cl, null);
                }
                catch (Throwable throwable3) {
                    try {
                        Class.forName("ch.qos.logback.classic.Logger", false, cl);
                        return LoggerProviders.trySlf4j(null);
                    }
                    catch (Throwable throwable4) {
                        return LoggerProviders.tryJDK(null);
                    }
                }
            }
        }
    }

    private static JDKLoggerProvider tryJDK(String via) {
        JDKLoggerProvider provider2 = new JDKLoggerProvider();
        LoggerProviders.logProvider(provider2, via);
        return provider2;
    }

    private static LoggerProvider trySlf4j(String via) {
        Slf4jLoggerProvider provider2 = new Slf4jLoggerProvider();
        LoggerProviders.logProvider(provider2, via);
        return provider2;
    }

    private static LoggerProvider tryLog4j2(ClassLoader cl, String via) throws ClassNotFoundException {
        Class.forName("org.apache.logging.log4j.Logger", true, cl);
        Class.forName("org.apache.logging.log4j.LogManager", true, cl);
        Class.forName("org.apache.logging.log4j.spi.AbstractLogger", true, cl);
        Log4j2LoggerProvider provider2 = new Log4j2LoggerProvider();
        LoggerProviders.logProvider(provider2, via);
        return provider2;
    }

    private static LoggerProvider tryLog4j(ClassLoader cl, String via) throws ClassNotFoundException {
        Class.forName("org.apache.log4j.LogManager", true, cl);
        Class.forName("org.apache.log4j.config.PropertySetter", true, cl);
        Log4jLoggerProvider provider2 = new Log4jLoggerProvider();
        LoggerProviders.logProvider(provider2, via);
        return provider2;
    }

    private static LoggerProvider tryJBossLogManager(ClassLoader cl, String via) throws ClassNotFoundException {
        Class<?> logManagerClass = LogManager.getLogManager().getClass();
        if (logManagerClass == Class.forName("org.jboss.logmanager.LogManager", false, cl) && Class.forName("org.jboss.logmanager.Logger$AttachmentKey", true, cl).getClassLoader() == logManagerClass.getClassLoader()) {
            JBossLogManagerProvider provider2 = new JBossLogManagerProvider();
            LoggerProviders.logProvider(provider2, via);
            return provider2;
        }
        throw new IllegalStateException();
    }

    private static void logProvider(LoggerProvider provider2, String via) {
        Logger logger2 = provider2.getLogger(LoggerProviders.class.getPackage().getName());
        if (via == null) {
            logger2.debugf("Logging Provider: %s", (Object)provider2.getClass().getName());
        } else {
            logger2.debugf("Logging Provider: %s found via %s", (Object)provider2.getClass().getName(), (Object)via);
        }
    }

    private LoggerProviders() {
    }
}

