/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.sdk.core.client;

import com.expediagroup.sdk.core.client.EnvironmentProvider;
import com.expediagroup.sdk.core.model.Properties;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpHeaders;
import java.net.URL;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0016R\u0016\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0006*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/expediagroup/sdk/core/client/DefaultEnvironmentProvider;", "Lcom/expediagroup/sdk/core/client/EnvironmentProvider;", "namespace", "", "(Ljava/lang/String;)V", "javaVersion", "kotlin.jvm.PlatformType", "operatingSystemName", "operatingSystemVersion", "properties", "Lcom/expediagroup/sdk/core/model/Properties;", "userAgent", "appendHeaders", "", "Lio/ktor/client/request/HttpRequestBuilder;", "rapid-sdk"})
public final class DefaultEnvironmentProvider
implements EnvironmentProvider {
    @NotNull
    private final Properties properties;
    private final String javaVersion;
    private final String operatingSystemName;
    private final String operatingSystemVersion;
    @NotNull
    private final String userAgent;

    public DefaultEnvironmentProvider(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        URL uRL = this.getClass().getClassLoader().getResource("sdk.properties");
        Intrinsics.checkNotNull((Object)uRL);
        this.properties = Properties.Companion.from(uRL);
        this.javaVersion = System.getProperty("java.version");
        this.operatingSystemName = System.getProperty("os.name");
        this.operatingSystemVersion = System.getProperty("os.version");
        StringBuilder stringBuilder = new StringBuilder().append("expediagroup-sdk-java-").append(namespace).append('/');
        String string = this.properties.get("sdk-version");
        Intrinsics.checkNotNull((Object)string);
        this.userAgent = stringBuilder.append(string).append(" (Java ").append(this.javaVersion).append("; ").append(this.operatingSystemName).append(' ').append(this.operatingSystemVersion).append(')').toString();
    }

    @Override
    public void appendHeaders(@NotNull HttpRequestBuilder $this$appendHeaders) {
        Intrinsics.checkNotNullParameter((Object)$this$appendHeaders, (String)"<this>");
        HeadersBuilder $this$appendHeaders_u24lambda_u240 = $this$appendHeaders.getHeaders();
        boolean bl = false;
        $this$appendHeaders_u24lambda_u240.append(HttpHeaders.INSTANCE.getUserAgent(), this.userAgent);
        String string = this.properties.get("sdk-title");
        Intrinsics.checkNotNull((Object)string);
        $this$appendHeaders_u24lambda_u240.append("x-sdk-title", string);
        String string2 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        $this$appendHeaders_u24lambda_u240.append("transaction-id", string2);
    }
}

