/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.sdk.core.plugin.authentication;

import com.expediagroup.sdk.core.client.Client;
import com.expediagroup.sdk.core.plugin.Plugin;
import com.expediagroup.sdk.core.plugin.authentication.AuthenticationConfiguration;
import com.expediagroup.sdk.core.plugin.authentication.strategy.AuthenticationStrategy;
import io.ktor.client.plugins.auth.Auth;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/expediagroup/sdk/core/plugin/authentication/AuthenticationPlugin;", "Lcom/expediagroup/sdk/core/plugin/Plugin;", "Lcom/expediagroup/sdk/core/plugin/authentication/AuthenticationConfiguration;", "()V", "clientAuthenticationStrategies", "", "Lcom/expediagroup/sdk/core/client/Client;", "Lcom/expediagroup/sdk/core/plugin/authentication/strategy/AuthenticationStrategy;", "getClientAuthenticationStrategies", "()Ljava/util/Map;", "install", "", "client", "configurations", "rapid-sdk"})
public final class AuthenticationPlugin
implements Plugin<AuthenticationConfiguration> {
    @NotNull
    public static final AuthenticationPlugin INSTANCE = new AuthenticationPlugin();
    @NotNull
    private static final Map<Client, AuthenticationStrategy> clientAuthenticationStrategies = new LinkedHashMap();

    private AuthenticationPlugin() {
    }

    @NotNull
    public final Map<Client, AuthenticationStrategy> getClientAuthenticationStrategies() {
        return clientAuthenticationStrategies;
    }

    @Override
    public void install(@NotNull Client client, @NotNull AuthenticationConfiguration configurations) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)configurations, (String)"configurations");
        AuthenticationStrategy strategy = AuthenticationStrategy.Companion.from(configurations, client);
        clientAuthenticationStrategies.put(client, strategy);
        configurations.getHttpClientConfiguration().install(Auth.Plugin, (Function1)new Function1<Auth, Unit>(strategy){
            final /* synthetic */ AuthenticationStrategy $strategy;
            {
                this.$strategy = $strategy;
                super(1);
            }

            public final void invoke(@NotNull Auth $this$install) {
                Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
                this.$strategy.loadAuth($this$install);
            }
        });
    }
}

