/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.sdk.core.plugin.authentication.strategy;

import com.expediagroup.sdk.core.client.Client;
import com.expediagroup.sdk.core.configuration.Credentials;
import com.expediagroup.sdk.core.constant.Constant;
import com.expediagroup.sdk.core.constant.provider.LoggingMessageProvider;
import com.expediagroup.sdk.core.model.HeadersKt;
import com.expediagroup.sdk.core.model.exception.service.ExpediaGroupAuthException;
import com.expediagroup.sdk.core.plugin.authentication.AuthenticationConfiguration;
import com.expediagroup.sdk.core.plugin.authentication.strategy.AuthenticationStrategy;
import com.expediagroup.sdk.core.plugin.logging.ExpediaGroupLogger;
import com.expediagroup.sdk.core.plugin.logging.ExpediaGroupLoggerFactory;
import io.ktor.client.HttpClient;
import io.ktor.client.plugins.HttpClientPluginKt;
import io.ktor.client.plugins.auth.Auth;
import io.ktor.client.plugins.auth.providers.BearerAuthConfig;
import io.ktor.client.plugins.auth.providers.BearerAuthProvider;
import io.ktor.client.plugins.auth.providers.BearerAuthProviderKt;
import io.ktor.client.plugins.auth.providers.BearerTokens;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestKt;
import io.ktor.client.request.UtilsKt;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpStatement;
import io.ktor.http.ContentType;
import io.ktor.http.HttpMessagePropertiesKt;
import io.ktor.http.HttpMethod;
import io.ktor.http.ParametersKt;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLBuilderKt;
import io.ktor.util.reflect.TypeInfoJvmKt;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\fH\u0016J\u0014\u0010\u001b\u001a\u00020\f*\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/expediagroup/sdk/core/plugin/authentication/strategy/ExpediaGroupAuthenticationStrategy;", "Lcom/expediagroup/sdk/core/plugin/authentication/strategy/AuthenticationStrategy;", "client", "Lcom/expediagroup/sdk/core/client/Client;", "configs", "Lcom/expediagroup/sdk/core/plugin/authentication/AuthenticationConfiguration;", "(Lcom/expediagroup/sdk/core/client/Client;Lcom/expediagroup/sdk/core/plugin/authentication/AuthenticationConfiguration;)V", "bearerTokenStorage", "Lcom/expediagroup/sdk/core/plugin/authentication/strategy/ExpediaGroupAuthenticationStrategy$BearerTokensInfo;", "log", "Lcom/expediagroup/sdk/core/plugin/logging/ExpediaGroupLogger;", "clearTokens", "", "Lio/ktor/client/HttpClient;", "getAuthorizationHeader", "", "getTokens", "Lio/ktor/client/plugins/auth/providers/BearerTokens;", "isIdentityRequest", "", "request", "Lio/ktor/client/request/HttpRequestBuilder;", "isTokenAboutToExpire", "loadAuth", "auth", "Lio/ktor/client/plugins/auth/Auth;", "renewToken", "basicAuth", "credentials", "Lcom/expediagroup/sdk/core/configuration/Credentials;", "BearerTokensInfo", "TokenResponse", "rapid-sdk"})
@SourceDebugExtension(value={"SMAP\nExpediaGroupAuthenticationStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpediaGroupAuthenticationStrategy.kt\ncom/expediagroup/sdk/core/plugin/authentication/strategy/ExpediaGroupAuthenticationStrategy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n1#2:140\n800#3,11:141\n*S KotlinDebug\n*F\n+ 1 ExpediaGroupAuthenticationStrategy.kt\ncom/expediagroup/sdk/core/plugin/authentication/strategy/ExpediaGroupAuthenticationStrategy\n*L\n97#1:141,11\n*E\n"})
public final class ExpediaGroupAuthenticationStrategy
implements AuthenticationStrategy {
    @NotNull
    private final Client client;
    @NotNull
    private final AuthenticationConfiguration configs;
    @NotNull
    private final ExpediaGroupLogger log;
    @NotNull
    private BearerTokensInfo bearerTokenStorage;

    public ExpediaGroupAuthenticationStrategy(@NotNull Client client, @NotNull AuthenticationConfiguration configs) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)configs, (String)"configs");
        this.client = client;
        this.configs = configs;
        this.log = ExpediaGroupLoggerFactory.INSTANCE.getLogger(this.getClass());
        this.bearerTokenStorage = BearerTokensInfo.Companion.getEmptyBearerTokenInfo$rapid_sdk();
    }

    @Override
    public void loadAuth(@NotNull Auth auth) {
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        BearerAuthProviderKt.bearer(auth, (Function1<? super BearerAuthConfig, Unit>)((Function1)new Function1<BearerAuthConfig, Unit>(this){
            final /* synthetic */ ExpediaGroupAuthenticationStrategy this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull BearerAuthConfig $this$bearer) {
                Intrinsics.checkNotNullParameter((Object)$this$bearer, (String)"$this$bearer");
                $this$bearer.sendWithoutRequest((Function1<? super HttpRequestBuilder, Boolean>)((Function1)new Function1<HttpRequestBuilder, Boolean>(this.this$0){
                    final /* synthetic */ ExpediaGroupAuthenticationStrategy this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull HttpRequestBuilder request2) {
                        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
                        return this.this$0.isIdentityRequest(request2);
                    }
                }));
            }
        }));
    }

    @Override
    public boolean isTokenAboutToExpire() {
        boolean bl;
        boolean it = bl = this.bearerTokenStorage.isAboutToExpire();
        boolean bl2 = false;
        if (it) {
            this.log.info("Token expired or is about to expire. Request will wait until token is renewed");
        }
        return bl;
    }

    @Override
    public void renewToken() {
        HttpClient httpClient = this.client.getHttpClient();
        this.log.info("Renewing token");
        this.clearTokens(httpClient);
        HttpResponse renewTokenResponse2 = (HttpResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super HttpResponse>, Object>(httpClient, this, null){
            int label;
            final /* synthetic */ HttpClient $httpClient;
            final /* synthetic */ ExpediaGroupAuthenticationStrategy this$0;
            {
                this.$httpClient = $httpClient;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$request$iv$iv;
                        HttpRequestBuilder httpRequestBuilder;
                        void $this$request$iv;
                        ResultKt.throwOnFailure((Object)object);
                        HttpClient httpClient = this.$httpClient;
                        ExpediaGroupAuthenticationStrategy expediaGroupAuthenticationStrategy = this.this$0;
                        boolean $i$f$request = false;
                        void var5_7 = $this$request$iv;
                        HttpRequestBuilder $this$invokeSuspend_u24lambda_u241 = httpRequestBuilder = new HttpRequestBuilder();
                        boolean bl = false;
                        $this$invokeSuspend_u24lambda_u241.setMethod(HttpMethod.Companion.getPost());
                        UtilsKt.parameter($this$invokeSuspend_u24lambda_u241, "grant_type", "client_credentials");
                        HttpMessagePropertiesKt.contentType($this$invokeSuspend_u24lambda_u241, ContentType.Application.INSTANCE.getFormUrlEncoded());
                        HttpRequestKt.url($this$invokeSuspend_u24lambda_u241, ExpediaGroupAuthenticationStrategy.access$getConfigs$p(expediaGroupAuthenticationStrategy).getAuthUrl());
                        ExpediaGroupAuthenticationStrategy.access$basicAuth(expediaGroupAuthenticationStrategy, $this$invokeSuspend_u24lambda_u241, ExpediaGroupAuthenticationStrategy.access$getConfigs$p(expediaGroupAuthenticationStrategy).getCredentials());
                        Client $this$invokeSuspend_u24lambda_u241_u24lambda_u240 = ExpediaGroupAuthenticationStrategy.access$getClient$p(expediaGroupAuthenticationStrategy);
                        boolean bl2 = false;
                        $this$invokeSuspend_u24lambda_u241_u24lambda_u240.appendHeaders($this$invokeSuspend_u24lambda_u241);
                        HttpRequestBuilder builder$iv$iv = httpRequestBuilder;
                        boolean $i$f$request2 = false;
                        this.label = 1;
                        Object object3 = new HttpStatement(builder$iv$iv, (HttpClient)$this$request$iv$iv).execute((Continuation<? super HttpResponse>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$request = false;
                        boolean $i$f$request3 = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super HttpResponse> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        IntRange intRange = Constant.INSTANCE.getSUCCESSFUL_STATUS_CODES_RANGE();
        int n = intRange.getFirst();
        int n2 = intRange.getLast();
        int n3 = renewTokenResponse2.getStatus().getValue();
        if (!(n <= n3 ? n3 <= n2 : false)) {
            throw new ExpediaGroupAuthException(renewTokenResponse2.getStatus(), "Unable to authenticate", HeadersKt.getTransactionId(renewTokenResponse2.getHeaders()));
        }
        TokenResponse renewedTokenInfo2 = (TokenResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TokenResponse>, Object>(renewTokenResponse2, null){
            int label;
            final /* synthetic */ HttpResponse $renewTokenResponse;
            {
                this.$renewTokenResponse = $renewTokenResponse;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$body$iv = this.$renewTokenResponse;
                        $i$f$body = false;
                        $i$f$typeInfo = false;
                        kType$iv$iv = Reflection.typeOf(TokenResponse.class);
                        reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                        this.label = 1;
                        v0 = $this$body$iv.getCall().bodyNullable(TypeInfoJvmKt.typeInfoImpl(reifiedType$iv$iv, Reflection.getOrCreateKotlinClass(TokenResponse.class), kType$iv$iv), (Continuation<Object>)((Continuation)this));
                        if (v0 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl19
                    }
                    case 1: {
                        $i$f$body = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl19:
                        // 2 sources

                        if (v0 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.expediagroup.sdk.core.plugin.authentication.strategy.ExpediaGroupAuthenticationStrategy.TokenResponse");
                        }
                        return (TokenResponse)v0;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super TokenResponse> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        this.log.info("Token renewal successful");
        this.log.info(LoggingMessageProvider.INSTANCE.getTokenExpiresInMessage(renewedTokenInfo2.getExpiresIn()));
        this.bearerTokenStorage = new BearerTokensInfo(new BearerTokens(renewedTokenInfo2.getAccessToken(), renewedTokenInfo2.getAccessToken()), renewedTokenInfo2.getExpiresIn());
    }

    /*
     * WARNING - void declaration
     */
    private final void clearTokens(HttpClient client) {
        void $this$filterIsInstanceTo$iv$iv;
        this.log.info("Clearing tokens");
        Iterable $this$filterIsInstance$iv = ((Auth)HttpClientPluginKt.plugin(client, Auth.Plugin)).getProviders();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof BearerAuthProvider)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ((BearerAuthProvider)CollectionsKt.first((List)((List)destination$iv$iv))).clearToken();
        this.bearerTokenStorage = BearerTokensInfo.Companion.getEmptyBearerTokenInfo$rapid_sdk();
        this.log.info("Tokens successfully cleared");
    }

    private final BearerTokens getTokens() {
        return this.bearerTokenStorage.getBearerTokens();
    }

    private final void basicAuth(HttpRequestBuilder $this$basicAuth, Credentials credentials) {
        UtilsKt.basicAuth($this$basicAuth, credentials.getKey(), credentials.getSecret());
    }

    @Override
    public boolean isIdentityRequest(@NotNull HttpRequestBuilder request2) {
        URLBuilder uRLBuilder;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        URLBuilder $this$isIdentityRequest_u24lambda_u241 = uRLBuilder = URLBuilderKt.clone(request2.getUrl());
        boolean bl = false;
        $this$isIdentityRequest_u24lambda_u241.setEncodedParameters(ParametersKt.ParametersBuilder$default(0, 1, null));
        return Intrinsics.areEqual((Object)uRLBuilder.buildString(), (Object)this.configs.getAuthUrl());
    }

    @Override
    @NotNull
    public String getAuthorizationHeader() {
        return "Bearer " + this.getTokens().getAccessToken();
    }

    public static final /* synthetic */ AuthenticationConfiguration access$getConfigs$p(ExpediaGroupAuthenticationStrategy $this) {
        return $this.configs;
    }

    public static final /* synthetic */ void access$basicAuth(ExpediaGroupAuthenticationStrategy $this, HttpRequestBuilder $receiver, Credentials credentials) {
        $this.basicAuth($receiver, credentials);
    }

    public static final /* synthetic */ Client access$getClient$p(ExpediaGroupAuthenticationStrategy $this) {
        return $this.client;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0010\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/expediagroup/sdk/core/plugin/authentication/strategy/ExpediaGroupAuthenticationStrategy$BearerTokensInfo;", "", "bearerTokens", "Lio/ktor/client/plugins/auth/providers/BearerTokens;", "expiresIn", "", "(Lio/ktor/client/plugins/auth/providers/BearerTokens;I)V", "getBearerTokens", "()Lio/ktor/client/plugins/auth/providers/BearerTokens;", "expiryDate", "Ljava/time/LocalDateTime;", "calculateExpiryDate", "isAboutToExpire", "", "Companion", "rapid-sdk"})
    public static class BearerTokensInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final BearerTokens bearerTokens;
        @NotNull
        private final LocalDateTime expiryDate;
        @NotNull
        private static final BearerTokensInfo emptyBearerTokenInfo;

        public BearerTokensInfo(@NotNull BearerTokens bearerTokens, int expiresIn) {
            Intrinsics.checkNotNullParameter((Object)bearerTokens, (String)"bearerTokens");
            this.bearerTokens = bearerTokens;
            this.expiryDate = this.calculateExpiryDate(expiresIn);
        }

        @NotNull
        public final BearerTokens getBearerTokens() {
            return this.bearerTokens;
        }

        private final LocalDateTime calculateExpiryDate(int expiresIn) {
            LocalDateTime localDateTime = LocalDateTime.now().plusSeconds(expiresIn);
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"plusSeconds(...)");
            return localDateTime;
        }

        public boolean isAboutToExpire() {
            return LocalDateTime.now().isAfter(this.expiryDate.minusSeconds(10L));
        }

        static {
            BearerTokens bearerTokens = new BearerTokens("", "");
            emptyBearerTokenInfo = new BearerTokensInfo(bearerTokens){

                public boolean isAboutToExpire() {
                    return true;
                }
            };
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/expediagroup/sdk/core/plugin/authentication/strategy/ExpediaGroupAuthenticationStrategy$BearerTokensInfo$Companion;", "", "()V", "emptyBearerTokenInfo", "Lcom/expediagroup/sdk/core/plugin/authentication/strategy/ExpediaGroupAuthenticationStrategy$BearerTokensInfo;", "getEmptyBearerTokenInfo$rapid_sdk", "()Lcom/expediagroup/sdk/core/plugin/authentication/strategy/ExpediaGroupAuthenticationStrategy$BearerTokensInfo;", "rapid-sdk"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BearerTokensInfo getEmptyBearerTokenInfo$rapid_sdk() {
                return emptyBearerTokenInfo;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/expediagroup/sdk/core/plugin/authentication/strategy/ExpediaGroupAuthenticationStrategy$TokenResponse;", "", "accessToken", "", "expiresIn", "", "(Ljava/lang/String;I)V", "getAccessToken", "()Ljava/lang/String;", "getExpiresIn", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "rapid-sdk"})
    public static final class TokenResponse {
        @NotNull
        private final String accessToken;
        private final int expiresIn;

        public TokenResponse(@NotNull String accessToken, int expiresIn) {
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            this.accessToken = accessToken;
            this.expiresIn = expiresIn;
        }

        @NotNull
        public final String getAccessToken() {
            return this.accessToken;
        }

        public final int getExpiresIn() {
            return this.expiresIn;
        }

        @NotNull
        public final String component1() {
            return this.accessToken;
        }

        public final int component2() {
            return this.expiresIn;
        }

        @NotNull
        public final TokenResponse copy(@NotNull String accessToken, int expiresIn) {
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            return new TokenResponse(accessToken, expiresIn);
        }

        public static /* synthetic */ TokenResponse copy$default(TokenResponse tokenResponse, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = tokenResponse.accessToken;
            }
            if ((n2 & 2) != 0) {
                n = tokenResponse.expiresIn;
            }
            return tokenResponse.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "TokenResponse(accessToken=" + this.accessToken + ", expiresIn=" + this.expiresIn + ')';
        }

        public int hashCode() {
            int result2 = this.accessToken.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.expiresIn);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TokenResponse)) {
                return false;
            }
            TokenResponse tokenResponse = (TokenResponse)other;
            if (!Intrinsics.areEqual((Object)this.accessToken, (Object)tokenResponse.accessToken)) {
                return false;
            }
            return this.expiresIn == tokenResponse.expiresIn;
        }
    }
}

