/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.sdk.core.plugin.authentication.strategy;

import com.expediagroup.sdk.core.configuration.Credentials;
import com.expediagroup.sdk.core.plugin.authentication.AuthenticationConfiguration;
import com.expediagroup.sdk.core.plugin.authentication.strategy.AuthenticationStrategy;
import io.ktor.client.plugins.auth.Auth;
import io.ktor.client.request.HttpRequestBuilder;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.spec.MGF1ParameterSpec;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/expediagroup/sdk/core/plugin/authentication/strategy/RapidAuthenticationStrategy;", "Lcom/expediagroup/sdk/core/plugin/authentication/strategy/AuthenticationStrategy;", "configs", "Lcom/expediagroup/sdk/core/plugin/authentication/AuthenticationConfiguration;", "(Lcom/expediagroup/sdk/core/plugin/authentication/AuthenticationConfiguration;)V", "signature", "", "calculateSignature", "apiKey", "secret", "timestamp", "", "createAuthorizationHeader", "getAuthorizationHeader", "isIdentityRequest", "", "request", "Lio/ktor/client/request/HttpRequestBuilder;", "isTokenAboutToExpire", "renewToken", "", "rapid-sdk"})
@SourceDebugExtension(value={"SMAP\nRapidAuthenticationStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RapidAuthenticationStrategy.kt\ncom/expediagroup/sdk/core/plugin/authentication/strategy/RapidAuthenticationStrategy\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,62:1\n13316#2,2:63\n*S KotlinDebug\n*F\n+ 1 RapidAuthenticationStrategy.kt\ncom/expediagroup/sdk/core/plugin/authentication/strategy/RapidAuthenticationStrategy\n*L\n55#1:63,2\n*E\n"})
public final class RapidAuthenticationStrategy
implements AuthenticationStrategy {
    @NotNull
    private final AuthenticationConfiguration configs;
    @NotNull
    private String signature;

    public RapidAuthenticationStrategy(@NotNull AuthenticationConfiguration configs) {
        Intrinsics.checkNotNullParameter((Object)configs, (String)"configs");
        this.configs = configs;
        this.signature = "";
    }

    @Override
    public boolean isTokenAboutToExpire() {
        return true;
    }

    @Override
    public void renewToken() {
        Credentials credentials = this.configs.getCredentials();
        this.signature = this.calculateSignature(credentials.getKey(), credentials.getSecret(), Instant.now().getEpochSecond());
    }

    @Override
    public boolean isIdentityRequest(@NotNull HttpRequestBuilder request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return false;
    }

    @Override
    @NotNull
    public String getAuthorizationHeader() {
        return this.createAuthorizationHeader(this.signature);
    }

    private final String createAuthorizationHeader(String signature) {
        return "EAN " + signature;
    }

    private final String calculateSignature(String apiKey, String secret2, long timestamp) {
        StringBuilder stringBuilder;
        String toBeHashed = apiKey + secret2 + timestamp;
        MessageDigest messageDigest = MessageDigest.getInstance(MGF1ParameterSpec.SHA512.getDigestAlgorithm());
        String string = toBeHashed;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = messageDigest.digest(byArray);
        StringBuilder $this$calculateSignature_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)bytes);
        byte[] $this$forEach$iv = bytes;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            byte element$iv;
            byte it = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            String string2 = Integer.toString((it & 0xFF) + 256, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String string3 = string2.substring(BigInteger.ONE.intValue());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            $this$calculateSignature_u24lambda_u241.append(string3);
        }
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        String signature = string4;
        return "apikey=" + apiKey + ",signature=" + signature + ",timestamp=" + timestamp;
    }

    @Override
    public void loadAuth(@NotNull Auth auth) {
        AuthenticationStrategy.DefaultImpls.loadAuth(this, auth);
    }
}

