/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.sdk.core.plugin.logging;

import com.expediagroup.sdk.core.client.Client;
import com.expediagroup.sdk.core.plugin.Plugin;
import com.expediagroup.sdk.core.plugin.logging.LoggingConfiguration;
import com.expediagroup.sdk.core.plugin.logging.LoggingMaskedFieldsProvider;
import com.expediagroup.sdk.core.plugin.logging.LoggingPluginKt;
import com.expediagroup.sdk.core.plugin.logging.RequestBodyLogger;
import com.expediagroup.sdk.core.plugin.logging.ResponseBodyLogger;
import io.ktor.client.HttpClientConfig;
import io.ktor.client.plugins.logging.Logger;
import io.ktor.client.plugins.logging.Logging;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/expediagroup/sdk/core/plugin/logging/LoggingPlugin;", "Lcom/expediagroup/sdk/core/plugin/Plugin;", "Lcom/expediagroup/sdk/core/plugin/logging/LoggingConfiguration;", "()V", "clientLoggingMaskedFieldsProviders", "", "Lcom/expediagroup/sdk/core/client/Client;", "Lcom/expediagroup/sdk/core/plugin/logging/LoggingMaskedFieldsProvider;", "getClientLoggingMaskedFieldsProviders", "()Ljava/util/Map;", "install", "", "client", "configurations", "rapid-sdk"})
public final class LoggingPlugin
implements Plugin<LoggingConfiguration> {
    @NotNull
    public static final LoggingPlugin INSTANCE = new LoggingPlugin();
    @NotNull
    private static final Map<Client, LoggingMaskedFieldsProvider> clientLoggingMaskedFieldsProviders = new LinkedHashMap();

    private LoggingPlugin() {
    }

    @NotNull
    public final Map<Client, LoggingMaskedFieldsProvider> getClientLoggingMaskedFieldsProviders() {
        return clientLoggingMaskedFieldsProviders;
    }

    @Override
    public void install(@NotNull Client client, @NotNull LoggingConfiguration configurations) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)configurations, (String)"configurations");
        clientLoggingMaskedFieldsProviders.put(client, new LoggingMaskedFieldsProvider(configurations.getMaskedLoggingHeaders(), configurations.getMaskedLoggingBodyFields()));
        configurations.getHttpClientConfiguration().install(Logging.Companion, (Function1)new Function1<Logging.Config, Unit>(configurations, client){
            final /* synthetic */ LoggingConfiguration $configurations;
            final /* synthetic */ Client $client;
            {
                this.$configurations = $configurations;
                this.$client = $client;
                super(1);
            }

            public final void invoke(@NotNull Logging.Config $this$install) {
                Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
                $this$install.setLogger((Logger)this.$configurations.getGetLogger().invoke((Object)this.$client));
                $this$install.setLevel(this.$configurations.getLevel());
                $this$install.sanitizeHeader("<-- omitted -->", (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(this.$client){
                    final /* synthetic */ Client $client;
                    {
                        this.$client = $client;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull String header) {
                        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
                        return LoggingPluginKt.getLoggingMaskedFieldsProvider(this.$client).getMaskedHeaderFields().contains(header);
                    }
                }));
            }
        });
        HttpClientConfig.install$default(configurations.getHttpClientConfiguration(), RequestBodyLogger.Plugin, null, 2, null);
        HttpClientConfig.install$default(configurations.getHttpClientConfiguration(), ResponseBodyLogger.Plugin, null, 2, null);
    }
}

