/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.constraintvalidators.bv.number;

import java.util.OptionalInt;

public final class InfinityNumberComparatorHelper {
    public static final OptionalInt LESS_THAN = OptionalInt.of(-1);
    public static final OptionalInt FINITE_VALUE = OptionalInt.empty();
    public static final OptionalInt GREATER_THAN = OptionalInt.of(1);

    private InfinityNumberComparatorHelper() {
    }

    public static OptionalInt infinityCheck(Double number, OptionalInt treatNanAs) {
        OptionalInt result2 = FINITE_VALUE;
        if (number == Double.NEGATIVE_INFINITY) {
            result2 = LESS_THAN;
        } else if (number.isNaN()) {
            result2 = treatNanAs;
        } else if (number == Double.POSITIVE_INFINITY) {
            result2 = GREATER_THAN;
        }
        return result2;
    }

    public static OptionalInt infinityCheck(Float number, OptionalInt treatNanAs) {
        OptionalInt result2 = FINITE_VALUE;
        if (number.floatValue() == Float.NEGATIVE_INFINITY) {
            result2 = LESS_THAN;
        } else if (number.isNaN()) {
            result2 = treatNanAs;
        } else if (number.floatValue() == Float.POSITIVE_INFINITY) {
            result2 = GREATER_THAN;
        }
        return result2;
    }
}

