/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.constraintvalidators.bv.number.sign;

import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.constraintvalidators.bv.number.sign.NumberSignHelper;
import java.math.BigDecimal;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.Negative;

public class NegativeValidatorForCharSequence
implements ConstraintValidator<Negative, CharSequence> {
    @Override
    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        try {
            return NumberSignHelper.signum(new BigDecimal(value.toString())) < 0;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

