/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.constraintvalidators.hv;

import com.expediagroup.sdk.dependencies.org.hibernate.validator.constraints.LuhnCheck;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.constraintvalidators.hv.ModCheckBase;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.util.ModUtil;
import java.util.List;
import javax.validation.ConstraintValidator;

public class LuhnCheckValidator
extends ModCheckBase
implements ConstraintValidator<LuhnCheck, CharSequence> {
    @Override
    public void initialize(LuhnCheck constraintAnnotation) {
        super.initialize(constraintAnnotation.startIndex(), constraintAnnotation.endIndex(), constraintAnnotation.checkDigitIndex(), constraintAnnotation.ignoreNonDigitCharacters());
    }

    @Override
    public boolean isCheckDigitValid(List<Integer> digits, char checkDigit) {
        int modResult = ModUtil.calculateLuhnMod10Check(digits);
        if (!Character.isDigit(checkDigit)) {
            return false;
        }
        int checkValue = this.extractDigit(checkDigit);
        return checkValue == modResult;
    }
}

