/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.engine.constraintvalidation;

import com.expediagroup.sdk.dependencies.org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorInitializationContext;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.spi.scripting.ScriptEvaluator;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.spi.scripting.ScriptEvaluatorFactory;
import java.time.Duration;
import javax.validation.ClockProvider;

public class HibernateConstraintValidatorInitializationContextImpl
implements HibernateConstraintValidatorInitializationContext {
    private final ScriptEvaluatorFactory scriptEvaluatorFactory;
    private final ClockProvider clockProvider;
    private final Duration temporalValidationTolerance;
    private final int hashCode;

    public HibernateConstraintValidatorInitializationContextImpl(ScriptEvaluatorFactory scriptEvaluatorFactory, ClockProvider clockProvider, Duration temporalValidationTolerance) {
        this.scriptEvaluatorFactory = scriptEvaluatorFactory;
        this.clockProvider = clockProvider;
        this.temporalValidationTolerance = temporalValidationTolerance;
        this.hashCode = this.createHashCode();
    }

    public static HibernateConstraintValidatorInitializationContextImpl of(HibernateConstraintValidatorInitializationContextImpl defaultContext, ScriptEvaluatorFactory scriptEvaluatorFactory, ClockProvider clockProvider, Duration temporalValidationTolerance) {
        if (scriptEvaluatorFactory == defaultContext.scriptEvaluatorFactory && clockProvider == defaultContext.clockProvider && temporalValidationTolerance.equals(defaultContext.temporalValidationTolerance)) {
            return defaultContext;
        }
        return new HibernateConstraintValidatorInitializationContextImpl(scriptEvaluatorFactory, clockProvider, temporalValidationTolerance);
    }

    @Override
    public ScriptEvaluator getScriptEvaluatorForLanguage(String languageName) {
        return this.scriptEvaluatorFactory.getScriptEvaluatorByLanguageName(languageName);
    }

    @Override
    public ClockProvider getClockProvider() {
        return this.clockProvider;
    }

    @Override
    public Duration getTemporalValidationTolerance() {
        return this.temporalValidationTolerance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HibernateConstraintValidatorInitializationContextImpl hibernateConstraintValidatorInitializationContextImpl = (HibernateConstraintValidatorInitializationContextImpl)o;
        if (this.scriptEvaluatorFactory != hibernateConstraintValidatorInitializationContextImpl.scriptEvaluatorFactory) {
            return false;
        }
        if (this.clockProvider != hibernateConstraintValidatorInitializationContextImpl.clockProvider) {
            return false;
        }
        return this.temporalValidationTolerance.equals(hibernateConstraintValidatorInitializationContextImpl.temporalValidationTolerance);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int createHashCode() {
        int result2 = System.identityHashCode(this.scriptEvaluatorFactory);
        result2 = 31 * result2 + System.identityHashCode(this.clockProvider);
        result2 = 31 * result2 + this.temporalValidationTolerance.hashCode();
        return result2;
    }
}

