/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.engine.constraintvalidation;

import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.engine.constraintvalidation.ConstraintTree;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorContextImpl;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorManager;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.engine.validationcontext.ValidationContext;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.engine.valuecontext.ValueContext;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.util.logging.Log;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.util.logging.LoggerFactory;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.validation.ConstraintValidator;

class SimpleConstraintTree<B extends Annotation>
extends ConstraintTree<B> {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());

    public SimpleConstraintTree(ConstraintValidatorManager constraintValidatorManager, ConstraintDescriptorImpl<B> descriptor, Type validatedValueType) {
        super(constraintValidatorManager, descriptor, validatedValueType);
    }

    @Override
    protected void validateConstraints(ValidationContext<?> validationContext, ValueContext<?, ?> valueContext, Collection<ConstraintValidatorContextImpl> violatedConstraintValidatorContexts) {
        if (LOG.isTraceEnabled()) {
            LOG.tracef("Validating value %s against constraint defined by %s.", valueContext.getCurrentValidatedValue(), (Object)this.descriptor);
        }
        ConstraintValidator validator = this.getInitializedConstraintValidator(validationContext, valueContext);
        ConstraintValidatorContextImpl constraintValidatorContext = validationContext.createConstraintValidatorContextFor(this.descriptor, valueContext.getPropertyPath());
        if (this.validateSingleConstraint(valueContext, constraintValidatorContext, validator).isPresent()) {
            violatedConstraintValidatorContexts.add(constraintValidatorContext);
        }
    }
}

