/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.engine.scripting;

import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.util.logging.Log;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.util.logging.LoggerFactory;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.util.privilegedactions.GetClassLoader;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.spi.scripting.AbstractCachingScriptEvaluatorFactory;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.spi.scripting.ScriptEngineScriptEvaluator;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.spi.scripting.ScriptEvaluationException;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.spi.scripting.ScriptEvaluator;
import java.lang.invoke.MethodHandles;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class DefaultScriptEvaluatorFactory
extends AbstractCachingScriptEvaluatorFactory {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private ClassLoader classLoader;
    private volatile ScriptEngineManager scriptEngineManager;
    private volatile ScriptEngineManager threadContextClassLoaderScriptEngineManager;

    public DefaultScriptEvaluatorFactory(ClassLoader externalClassLoader) {
        this.classLoader = externalClassLoader == null ? DefaultScriptEvaluatorFactory.class.getClassLoader() : externalClassLoader;
    }

    @Override
    public void clear() {
        super.clear();
        this.classLoader = null;
        this.scriptEngineManager = null;
        this.threadContextClassLoaderScriptEngineManager = null;
    }

    @Override
    protected ScriptEvaluator createNewScriptEvaluator(String languageName) throws ScriptEvaluationException {
        ScriptEngine engine2 = this.getScriptEngineManager().getEngineByName(languageName);
        if (engine2 == null) {
            engine2 = this.getThreadContextClassLoaderScriptEngineManager().getEngineByName(languageName);
        }
        if (engine2 == null) {
            throw LOG.getUnableToFindScriptEngineException(languageName);
        }
        return new ScriptEngineScriptEvaluator(engine2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScriptEngineManager getScriptEngineManager() {
        if (this.scriptEngineManager == null) {
            DefaultScriptEvaluatorFactory defaultScriptEvaluatorFactory = this;
            synchronized (defaultScriptEvaluatorFactory) {
                if (this.scriptEngineManager == null) {
                    this.scriptEngineManager = new ScriptEngineManager(this.classLoader);
                }
            }
        }
        return this.scriptEngineManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScriptEngineManager getThreadContextClassLoaderScriptEngineManager() {
        if (this.threadContextClassLoaderScriptEngineManager == null) {
            DefaultScriptEvaluatorFactory defaultScriptEvaluatorFactory = this;
            synchronized (defaultScriptEvaluatorFactory) {
                if (this.threadContextClassLoaderScriptEngineManager == null) {
                    this.threadContextClassLoaderScriptEngineManager = new ScriptEngineManager(DefaultScriptEvaluatorFactory.run(GetClassLoader.fromContext()));
                }
            }
        }
        return this.threadContextClassLoaderScriptEngineManager;
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }
}

