/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.metadata.descriptor;

import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.metadata.descriptor.CrossParameterDescriptorImpl;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.metadata.descriptor.ElementDescriptorImpl;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.util.CollectionHelper;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.validation.metadata.ConstructorDescriptor;
import javax.validation.metadata.CrossParameterDescriptor;
import javax.validation.metadata.MethodDescriptor;
import javax.validation.metadata.ParameterDescriptor;
import javax.validation.metadata.ReturnValueDescriptor;

public class ExecutableDescriptorImpl
extends ElementDescriptorImpl
implements ConstructorDescriptor,
MethodDescriptor {
    private final String name;
    private final List<ParameterDescriptor> parameters;
    private final CrossParameterDescriptor crossParameterDescriptor;
    private final ReturnValueDescriptor returnValueDescriptor;
    private final boolean isGetter;

    public ExecutableDescriptorImpl(Type returnType, String name, Set<ConstraintDescriptorImpl<?>> crossParameterConstraints, ReturnValueDescriptor returnValueDescriptor, List<ParameterDescriptor> parameters2, boolean defaultGroupSequenceRedefined, boolean isGetter, List<Class<?>> defaultGroupSequence) {
        super(returnType, Collections.emptySet(), defaultGroupSequenceRedefined, defaultGroupSequence);
        this.name = name;
        this.parameters = CollectionHelper.toImmutableList(parameters2);
        this.returnValueDescriptor = returnValueDescriptor;
        this.crossParameterDescriptor = new CrossParameterDescriptorImpl(crossParameterConstraints, defaultGroupSequenceRedefined, defaultGroupSequence);
        this.isGetter = isGetter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<ParameterDescriptor> getParameterDescriptors() {
        return this.parameters;
    }

    @Override
    public ReturnValueDescriptor getReturnValueDescriptor() {
        return this.returnValueDescriptor;
    }

    @Override
    public boolean hasConstrainedParameters() {
        if (this.crossParameterDescriptor.hasConstraints()) {
            return true;
        }
        for (ParameterDescriptor oneParameter : this.parameters) {
            if (!oneParameter.hasConstraints() && !oneParameter.isCascaded()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasConstrainedReturnValue() {
        return this.returnValueDescriptor != null && (this.returnValueDescriptor.hasConstraints() || this.returnValueDescriptor.isCascaded());
    }

    @Override
    public CrossParameterDescriptor getCrossParameterDescriptor() {
        return this.crossParameterDescriptor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ExecutableDescriptorImpl");
        sb.append("{name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean isGetter() {
        return this.isGetter;
    }
}

