/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.metadata.location;

import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.engine.path.PathImpl;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.properties.Constrainable;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.util.ExecutableParameterNameProvider;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.util.TypeHelper;
import java.lang.reflect.Type;

class BeanConstraintLocation
implements ConstraintLocation {
    private final Class<?> declaringClass;
    private final Type typeForValidatorResolution;

    BeanConstraintLocation(Class<?> declaringClass) {
        this.declaringClass = declaringClass;
        this.typeForValidatorResolution = declaringClass.getTypeParameters().length == 0 ? declaringClass : TypeHelper.parameterizedType(declaringClass, declaringClass.getTypeParameters());
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public Constrainable getConstrainable() {
        return null;
    }

    @Override
    public Type getTypeForValidatorResolution() {
        return this.typeForValidatorResolution;
    }

    @Override
    public void appendTo(ExecutableParameterNameProvider parameterNameProvider, PathImpl path) {
        path.addBeanNode();
    }

    @Override
    public Object getValue(Object parent) {
        return parent;
    }

    @Override
    public ConstraintLocation.ConstraintLocationKind getKind() {
        return ConstraintLocation.ConstraintLocationKind.TYPE;
    }

    public String toString() {
        return "BeanConstraintLocation [declaringClass=" + this.declaringClass + ", typeForValidatorResolution=" + this.typeForValidatorResolution + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.declaringClass == null ? 0 : this.declaringClass.hashCode());
        result2 = 31 * result2 + (this.typeForValidatorResolution == null ? 0 : this.typeForValidatorResolution.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BeanConstraintLocation other = (BeanConstraintLocation)obj;
        if (this.declaringClass == null ? other.declaringClass != null : !this.declaringClass.equals(other.declaringClass)) {
            return false;
        }
        return !(this.typeForValidatorResolution == null ? other.typeForValidatorResolution != null : !this.typeForValidatorResolution.equals(other.typeForValidatorResolution));
    }
}

