/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.sdk.dependencies.org.hibernate.validator.resourceloading;

import com.expediagroup.sdk.dependencies.org.hibernate.validator.Incubating;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.util.CollectionHelper;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.internal.util.Contracts;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.resourceloading.AggregateResourceBundle;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.resourceloading.DelegatingResourceBundleLocator;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.resourceloading.PlatformResourceBundleLocator;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;

public class AggregateResourceBundleLocator
extends DelegatingResourceBundleLocator {
    private final List<PlatformResourceBundleLocator> resourceBundleLocators;

    public AggregateResourceBundleLocator(List<String> bundleNames) {
        this(bundleNames, false, Collections.emptySet(), null);
    }

    public AggregateResourceBundleLocator(List<String> bundleNames, ResourceBundleLocator delegate) {
        this(bundleNames, false, Collections.emptySet(), delegate, null);
    }

    public AggregateResourceBundleLocator(List<String> bundleNames, ResourceBundleLocator delegate, ClassLoader classLoader) {
        this(bundleNames, false, Collections.emptySet(), delegate, classLoader);
    }

    @Incubating
    public AggregateResourceBundleLocator(List<String> bundleNames, boolean preloadResourceBundles, Set<Locale> localesToInitialize) {
        this(bundleNames, preloadResourceBundles, localesToInitialize, null);
    }

    @Incubating
    public AggregateResourceBundleLocator(List<String> bundleNames, boolean preloadResourceBundles, Set<Locale> localesToInitialize, ResourceBundleLocator delegate) {
        this(bundleNames, preloadResourceBundles, localesToInitialize, delegate, null);
    }

    @Incubating
    public AggregateResourceBundleLocator(List<String> bundleNames, boolean preloadResourceBundles, Set<Locale> localesToInitialize, ResourceBundleLocator delegate, ClassLoader classLoader) {
        super(delegate);
        Contracts.assertValueNotNull(bundleNames, "bundleNames");
        ArrayList<PlatformResourceBundleLocator> tmpBundleLocators = new ArrayList<PlatformResourceBundleLocator>(bundleNames.size());
        for (String bundleName : bundleNames) {
            tmpBundleLocators.add(new PlatformResourceBundleLocator(bundleName, preloadResourceBundles ? localesToInitialize : Collections.emptySet(), classLoader));
        }
        this.resourceBundleLocators = CollectionHelper.toImmutableList(tmpBundleLocators);
    }

    @Override
    public ResourceBundle getResourceBundle(Locale locale) {
        ArrayList<ResourceBundle> sourceBundles = new ArrayList<ResourceBundle>();
        for (PlatformResourceBundleLocator resourceBundleLocator : this.resourceBundleLocators) {
            ResourceBundle resourceBundle = resourceBundleLocator.getResourceBundle(locale);
            if (resourceBundle == null) continue;
            sourceBundles.add(resourceBundle);
        }
        ResourceBundle bundleFromDelegate = super.getResourceBundle(locale);
        if (bundleFromDelegate != null) {
            sourceBundles.add(bundleFromDelegate);
        }
        return sourceBundles.isEmpty() ? null : new AggregateResourceBundle(sourceBundles);
    }

    @Deprecated
    public static class AggregateBundle
    extends AggregateResourceBundle {
        public AggregateBundle(List<ResourceBundle> bundles) {
            super(bundles);
        }
    }
}

