/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.sdk.dependencies.org.hibernate.validator.spi.scripting;

import com.expediagroup.sdk.dependencies.org.hibernate.validator.Incubating;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.spi.scripting.ScriptEvaluator;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.spi.scripting.ScriptEvaluatorFactory;
import com.expediagroup.sdk.dependencies.org.hibernate.validator.spi.scripting.ScriptEvaluatorNotFoundException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Incubating
public abstract class AbstractCachingScriptEvaluatorFactory
implements ScriptEvaluatorFactory {
    private final ConcurrentMap<String, ScriptEvaluator> scriptEvaluatorCache = new ConcurrentHashMap<String, ScriptEvaluator>();

    @Override
    public ScriptEvaluator getScriptEvaluatorByLanguageName(String languageName) {
        return this.scriptEvaluatorCache.computeIfAbsent(languageName, this::createNewScriptEvaluator);
    }

    @Override
    public void clear() {
        this.scriptEvaluatorCache.clear();
    }

    protected abstract ScriptEvaluator createNewScriptEvaluator(String var1) throws ScriptEvaluatorNotFoundException;
}

