/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.websocket;

import io.ktor.util.NIOKt;
import io.ktor.websocket.Frame;
import io.ktor.websocket.FrameType;
import io.ktor.websocket.UtilsKt;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0012J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0004J \u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\f\u0010#\u001a\u00020\u0004*\u00020\u0004H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lio/ktor/websocket/Serializer;", "", "()V", "frameBody", "Ljava/nio/ByteBuffer;", "hasOutstandingBytes", "", "getHasOutstandingBytes", "()Z", "lastDataFrameType", "Lio/ktor/websocket/FrameType;", "maskBuffer", "masking", "getMasking", "setMasking", "(Z)V", "messages", "Ljava/util/concurrent/ArrayBlockingQueue;", "Lio/ktor/websocket/Frame;", "remainingCapacity", "", "getRemainingCapacity", "()I", "enqueue", "", "f", "estimateFrameHeaderSize", "mask", "maskSize", "serialize", "buffer", "serializeHeader", "frame", "setMaskBuffer", "writeCurrentPayload", "maskedIfNeeded", "ktor-websockets"})
@SourceDebugExtension(value={"SMAP\nSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Serializer.kt\nio/ktor/websocket/Serializer\n+ 2 Utils.kt\nio/ktor/websocket/UtilsKt__UtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n14#2:129\n14#2:130\n14#2:131\n14#2:132\n14#2:133\n1#3:134\n*S KotlinDebug\n*F\n+ 1 Serializer.kt\nio/ktor/websocket/Serializer\n*L\n76#1:129\n77#1:130\n78#1:131\n79#1:132\n83#1:133\n*E\n"})
public final class Serializer {
    @NotNull
    private final ArrayBlockingQueue<Frame> messages = new ArrayBlockingQueue(1024);
    @Nullable
    private ByteBuffer frameBody;
    @Nullable
    private ByteBuffer maskBuffer;
    @Nullable
    private FrameType lastDataFrameType;
    private boolean masking;

    public final boolean getMasking() {
        return this.masking;
    }

    public final void setMasking(boolean bl) {
        this.masking = bl;
    }

    public final boolean getHasOutstandingBytes() {
        return !((Collection)this.messages).isEmpty() || this.frameBody != null;
    }

    public final int getRemainingCapacity() {
        return this.messages.remainingCapacity();
    }

    public final void enqueue(@NotNull Frame f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        this.messages.put(f);
    }

    public final void serialize(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        while (this.writeCurrentPayload(buffer) && this.messages.peek() != null) {
            Frame frame;
            boolean mask2 = this.masking;
            this.setMaskBuffer(mask2);
            int headerSize = this.estimateFrameHeaderSize(frame, mask2);
            if (buffer.remaining() < headerSize) break;
            this.serializeHeader(frame, buffer, mask2);
            this.messages.remove();
            this.frameBody = this.maskedIfNeeded(frame.getBuffer());
        }
    }

    private final void serializeHeader(Frame frame, ByteBuffer buffer, boolean mask2) {
        block11: {
            ByteBuffer byteBuffer;
            boolean $this$flagAt$iv;
            int n;
            int size = frame.getBuffer().remaining();
            int formattedLength = size < 126 ? size : (size <= 65535 ? 126 : 127);
            FrameType frameType = this.lastDataFrameType;
            if (frameType == null) {
                if (!frame.getFin()) {
                    this.lastDataFrameType = frame.getFrameType();
                }
                n = frame.getFrameType().getOpcode();
            } else if (frameType == frame.getFrameType()) {
                if (frame.getFin()) {
                    this.lastDataFrameType = null;
                }
                n = 0;
            } else {
                if (!frame.getFrameType().getControlFrame()) {
                    throw new IllegalStateException("Can't continue with different data frame opcode");
                }
                n = frame.getFrameType().getOpcode();
            }
            int continuationOpcode = n;
            boolean bl = frame.getFin();
            int at$iv = 7;
            boolean $i$f$flagAt = false;
            int n2 = $this$flagAt$iv ? 1 << at$iv : 0;
            $this$flagAt$iv = frame.getRsv1();
            at$iv = 6;
            $i$f$flagAt = false;
            int n3 = n2 | ($this$flagAt$iv ? 1 << at$iv : 0);
            $this$flagAt$iv = frame.getRsv2();
            at$iv = 5;
            $i$f$flagAt = false;
            int n4 = n3 | ($this$flagAt$iv ? 1 << at$iv : 0);
            $this$flagAt$iv = frame.getRsv3();
            at$iv = 4;
            $i$f$flagAt = false;
            int header = n4 | ($this$flagAt$iv ? 1 << at$iv : 0) | continuationOpcode;
            buffer.put((byte)header);
            $this$flagAt$iv = mask2;
            at$iv = 7;
            $i$f$flagAt = false;
            buffer.put((byte)(($this$flagAt$iv ? 1 << at$iv : 0) | formattedLength));
            switch (formattedLength) {
                case 126: {
                    buffer.putShort((short)frame.getBuffer().remaining());
                    break;
                }
                case 127: {
                    buffer.putLong(frame.getBuffer().remaining());
                }
            }
            if ((byteBuffer = this.maskBuffer) == null || (byteBuffer = byteBuffer.duplicate()) == null) break block11;
            NIOKt.moveTo$default(byteBuffer, buffer, 0, 2, null);
        }
    }

    private final int estimateFrameHeaderSize(Frame f, boolean mask2) {
        int size = f.getBuffer().remaining();
        return (size < 126 ? 2 : (size <= Short.MAX_VALUE ? 4 : 10)) + this.maskSize(mask2);
    }

    private final boolean writeCurrentPayload(ByteBuffer buffer) {
        ByteBuffer byteBuffer = this.frameBody;
        if (byteBuffer == null) {
            return true;
        }
        ByteBuffer frame = byteBuffer;
        NIOKt.moveTo$default(frame, buffer, 0, 2, null);
        if (!frame.hasRemaining()) {
            this.frameBody = null;
            return true;
        }
        return false;
    }

    private final int maskSize(boolean mask2) {
        return mask2 ? 4 : 0;
    }

    private final ByteBuffer maskedIfNeeded(ByteBuffer $this$maskedIfNeeded) {
        ByteBuffer byteBuffer;
        block3: {
            block2: {
                ByteBuffer byteBuffer2;
                byteBuffer = this.maskBuffer;
                if (byteBuffer == null) break block2;
                ByteBuffer mask2 = byteBuffer;
                boolean bl = false;
                ByteBuffer $this$maskedIfNeeded_u24lambda_u241_u24lambda_u240 = byteBuffer2 = NIOKt.copy$default($this$maskedIfNeeded, 0, 1, null);
                boolean bl2 = false;
                UtilsKt.xor($this$maskedIfNeeded_u24lambda_u241_u24lambda_u240, mask2);
                ByteBuffer byteBuffer3 = byteBuffer2;
                byteBuffer = byteBuffer3;
                if (byteBuffer3 != null) break block3;
            }
            byteBuffer = $this$maskedIfNeeded;
        }
        return byteBuffer;
    }

    /*
     * WARNING - void declaration
     */
    private final void setMaskBuffer(boolean mask2) {
        if (mask2) {
            void $this$setMaskBuffer_u24lambda_u242;
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2 = byteBuffer = ByteBuffer.allocate(4);
            Serializer serializer = this;
            boolean bl = false;
            $this$setMaskBuffer_u24lambda_u242.putInt(Random.Default.nextInt());
            $this$setMaskBuffer_u24lambda_u242.clear();
            serializer.maskBuffer = byteBuffer;
        } else {
            this.maskBuffer = null;
        }
    }
}

